package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.scalabilitytests;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.After;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.ConnectionManagerFactory;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.OvidConfiguration;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.pooled.OvidConnectionManagerWithPooling;
import com.agilex.healthcare.mobilehealthplatform.ovid.HospitalLocationRepository;
import com.agilex.healthcare.mobilehealthplatform.ovid.MedicationRepository;
import com.medsphere.vistarpc.RPCConnection;
import com.medsphere.vistarpc.RPCException;

@Ignore
public class OvidConnectionPoolManagerTest {

	public static final int NUM_REPOSITORIES = 30;
	OvidConnectionManagerWithPooling connectionManager;

	@Before
	public void setUp() throws Exception {
		// get the configuration from cocoon to get the right server location
		// and credentials
		OvidConfiguration configuration = ConnectionManagerFactory.getConfiguration();
		// force using pool
		configuration.setUsePool(true);
		// set the initial server connections and max free connections
		configuration.setInitialServerConnections(2);
		configuration.setInitialUserConnections(2);
		configuration.setMaxFreeServerConnections(10);
		configuration.setMaxFreeUserConnections(10);
		connectionManager = new OvidConnectionManagerWithPooling(configuration);
	}

	@After
	public void tearDown() throws Exception {
		connectionManager.terminateAllConnections();
	}

	@Ignore
	public void validateCreateConnections() throws RPCException {
		System.out.println("server connections free:" + connectionManager.getNumServerConnectionsFree());
		System.out.println("server connections used:" + connectionManager.getNumServerConnectionsUsed());
		assertTrue(connectionManager.getNumServerConnectionsFree() == 2);
		assertTrue(connectionManager.getNumServerConnectionsUsed() == 0);
		assertTrue(connectionManager.getNumUserConnectionsFree() == 2);
		assertTrue(connectionManager.getNumUserConnectionsUsed() == 0);

		for (int i = 0; i < 2; i++) {
			connectionManager.getServerConnection();
		}
		assertTrue(connectionManager.getNumServerConnectionsFree() == 0);
		assertTrue(connectionManager.getNumServerConnectionsUsed() == 2);
		assertTrue(connectionManager.getNumUserConnectionsFree() == 2);
		assertTrue(connectionManager.getNumUserConnectionsUsed() == 0);
		for (int i = 0; i < 2; i++) {
			connectionManager.getServerConnection();
			connectionManager.getUserConnection();
		}
		assertTrue(connectionManager.getNumServerConnectionsFree() == 0);
		assertTrue(connectionManager.getNumServerConnectionsUsed() == 4);
		assertTrue(connectionManager.getNumUserConnectionsFree() == 0);
		assertTrue(connectionManager.getNumUserConnectionsUsed() == 2);
	}

	@Ignore
	public void validateCreateRepository() throws RPCException {
		HospitalLocationRepository repo = connectionManager.getHospitalLocationRepository();
		assertTrue(repo != null);
		assertTrue(connectionManager.getNumServerConnectionsFree() == 1);
		assertTrue(connectionManager.getNumServerConnectionsUsed() == 1);
		assertTrue(connectionManager.getNumUserConnectionsFree() == 2);
		assertTrue(connectionManager.getNumUserConnectionsUsed() == 0);
		connectionManager.releaseRepositoryConnections(repo);
		assertTrue(connectionManager.getNumServerConnectionsFree() == 2);
		assertTrue(connectionManager.getNumServerConnectionsUsed() == 0);
		assertTrue(connectionManager.getNumUserConnectionsFree() == 2);
		assertTrue(connectionManager.getNumUserConnectionsUsed() == 0);
	}

	@Ignore
	public void validateTerminateConnections() throws RPCException {
		assertTrue(connectionManager.getNumServerConnectionsFree() == 2);
		assertTrue(connectionManager.getNumServerConnectionsUsed() == 0);
		assertTrue(connectionManager.getNumUserConnectionsFree() == 2);
		assertTrue(connectionManager.getNumUserConnectionsUsed() == 0);
		connectionManager.terminateAllConnections();
		assertTrue(connectionManager.getNumServerConnectionsFree() == 0);
		assertTrue(connectionManager.getNumServerConnectionsUsed() == 0);
		assertTrue(connectionManager.getNumUserConnectionsFree() == 0);
		assertTrue(connectionManager.getNumUserConnectionsUsed() == 0);
	}

	private void validateFreeConnections(int expectedFreeConnections, int expectedUsedConnections) {
		assertEquals(expectedFreeConnections, connectionManager.getNumServerConnectionsFree());
		assertEquals(expectedUsedConnections, connectionManager.getNumServerConnectionsUsed());
	}

	@Test
	public void validateMaxFreeConnections() throws RPCException {
		try {
			// validateFreeConnections(2, 0);
			RPCConnection con1 = connectionManager.getServerConnection();
			validateFreeConnections(1, 1);
			RPCConnection con2 = connectionManager.getServerConnection();
			RPCConnection con3 = connectionManager.getServerConnection();
			validateFreeConnections(0, 3);
			RPCConnection con4 = connectionManager.getServerConnection();
			RPCConnection con5 = connectionManager.getServerConnection();
			RPCConnection con6 = connectionManager.getServerConnection();
			RPCConnection con7 = connectionManager.getServerConnection();
			RPCConnection con8 = connectionManager.getServerConnection();
			RPCConnection con9 = connectionManager.getServerConnection();
			RPCConnection con10 = connectionManager.getServerConnection();
			RPCConnection con11 = connectionManager.getServerConnection();
			validateFreeConnections(0, 11);
			connectionManager.releaseConnection(con1);
			connectionManager.releaseConnection(con2);
			connectionManager.releaseConnection(con3);
			connectionManager.releaseConnection(con4);
			validateFreeConnections(4, 7);
			connectionManager.releaseConnection(con5);
			connectionManager.releaseConnection(con6);
			validateFreeConnections(6, 5);
			connectionManager.releaseConnection(con7);
			connectionManager.releaseConnection(con8);
			connectionManager.releaseConnection(con9);
			connectionManager.releaseConnection(con10);
			validateFreeConnections(10, 1);
			connectionManager.releaseConnection(con11);
			validateFreeConnections(10, 0);
		} finally {
			connectionManager.terminateAllConnections();
		}
	}

	@Ignore
	public void scalabilityTestWithClosingConnections() throws RPCException {
		final long startTime = System.nanoTime();
		final long endTime;

		MedicationRepository[] medicationRepositories = new MedicationRepository[NUM_REPOSITORIES];
		for (MedicationRepository repo : medicationRepositories) {
			repo = connectionManager.getMedicationRepository();
			connectionManager.releaseRepositoryConnections(repo);
		}

		endTime = System.nanoTime();
		final long duration = endTime - startTime;
		System.out.println("scalabilityTestWithClosingConnections time = " + duration + " seconds");
	}

}
