package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.scalabilitytests;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import java.util.Collection;

import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.PatientDataLayerOvid;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.ConnectionManagerFactory;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.connectionmanagement.IOvidConnectionManager;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.medsphere.fmdomain.FMPatient;
import com.medsphere.ovid.domain.ov.OvidDomainException;
import com.medsphere.ovid.domain.ov.PatientRepository;

@Ignore
public class OvidConnectionManagerWithNoCacheTest {
	
	@Test
	public void sample(){
		
	}

	@Ignore
	public void oldWay() {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setPrototype(new Patient());
		criteria.getPrototype().setLastName("younger");

		PatientDataLayerOvid datalayer = new PatientDataLayerOvid();
		Patients patients = datalayer.patientSearch(criteria);
		assertNotNull(patients);
		assertEquals(1, patients.size());
	}

	@Ignore
	public void performSingleSearch() throws OvidDomainException {
		IOvidConnectionManager connectionManager = ConnectionManagerFactory.getInstance();
		PatientRepository repo = connectionManager.getPatientRepository();
		Collection<FMPatient> patients = repo.lookupPatientsByName("younger");
		assertEquals(1, patients.size());
		connectionManager.releaseRepositoryConnections(repo);
	}

	private int numberOfSearches = 20;

	@Ignore
	// @Test(timeout=20000)
	public void performMultipleSearchesx20() throws OvidDomainException {
		for (int i = 1; i <= numberOfSearches; i++) {
			System.out.println("search #" + i);
			IOvidConnectionManager connectionManager = ConnectionManagerFactory.getInstance();
			PatientRepository repo = connectionManager.getPatientRepository();
			Collection<FMPatient> patients = repo.lookupPatientsByName("younger");
			assertEquals(1, patients.size());
			connectionManager.releaseRepositoryConnections(repo);
			System.out.println("done with search #" + i);
		}
	}

	@Ignore
	// @Test(timeout=20000)
	public void performMultipleSearchesCacheConnectionManagerx20() throws OvidDomainException {
		IOvidConnectionManager connectionManager = ConnectionManagerFactory.getInstance();
		for (int i = 1; i <= numberOfSearches; i++) {
			System.out.println("search #" + i);
			PatientRepository repo = connectionManager.getPatientRepository();
			Collection<FMPatient> patients = repo.lookupPatientsByName("younger");
			assertEquals(1, patients.size());
			connectionManager.releaseRepositoryConnections(repo);
			System.out.println("done with search #" + i);
		}
	}

	@Ignore
	// @Test(timeout=20000)
	public void performMultipleSearchesCacheRepox20() throws OvidDomainException {
		IOvidConnectionManager connectionManager = ConnectionManagerFactory.getInstance();
		PatientRepository repo = connectionManager.getPatientRepository();
		for (int i = 1; i <= numberOfSearches; i++) {
			System.out.println("search #" + i);
			Collection<FMPatient> patients = repo.lookupPatientsByName("younger");
			assertEquals(1, patients.size());
			System.out.println("done with search #" + i);
		}
	}

}
