package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.scalabilitytests;

import static org.junit.Assert.assertNotNull;

import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.AllergyDataLayerOvid;
import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.ProblemDataLayerOpenSourceOvid;
import com.agilex.healthcare.mobilehealthplatform.datalayer.problem.ProblemDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Problem;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;

@Ignore
public class OvidConnectionManagerTest {

	private Patient loadPatient() { 
		Patient testPatient = IntegrationTestConfiguration.getTestPatient();
		return testPatient;
	}
	
	@Test
	public void retrievePatientOneTime() {
		Patient testPatient =loadPatient();
		assertNotNull(testPatient);
	}

	@Test
	public void retrievePatient20Times() {
		for (int i = 1; i <= 20; i++) {
			System.out.println(i);
			Patient testPatient =loadPatient();
			assertNotNull(testPatient);
		}
	}

	@Test
	public void retrievePatient100Times() {
		for (int i = 1; i <= 100; i++) {
			System.out.println(i);
			Patient testPatient =loadPatient();
			assertNotNull(testPatient);
		}
	}

//	@Test
//	public void retrievePatientAndProblemOneTime() {
//		System.out.println(" get patient");
//		Patient testPatient =loadPatient();
//		System.out.println(" got patient");
//		assertNotNull(testPatient);
//		System.out.println(" get problem");
//		Problem testProblem = getTestProblem(testPatient.getId());
//		assertNotNull(testProblem);
//		System.out.println(" got problem");
//	}

//	@Test
//	public void retrievePatientAndProblem20Times() {
//		for (int i = 1; i <= 20; i++) {
//			System.out.println(i + " get patient");
//			Patient testPatient =loadPatient();
//			System.out.println(i + " got patient");
//			assertNotNull(testPatient);
//			System.out.println(i + " get problem");
//			Problem testProblem = getTestProblem(testPatient.getId());
//			System.out.println(i + " got problem");
//			assertNotNull(testProblem);
//		}
//	}

	@Ignore
	public void retrievePatientAndAllergy20Times() {
		for (int i = 1; i <= 20; i++) {
			System.out.println(i + " get patient");
			Patient testPatient =loadPatient();
			System.out.println(i + " got patient");
			assertNotNull(testPatient);
			System.out.println(i + " get allergy");
			Allergy testAllergy = getTestAllergy(testPatient.getId());
			System.out.println(i + " got allergy");
			assertNotNull(testAllergy);
		}
	}

//	private Problem getTestProblem(String patientId) {
//		ProblemDataLayer dao = new ProblemDataLayerOpenSourceOvid();
//		Problems problems = dao.fetchProblems(patientId);
//		Problem problem = problems.get(0);
//		return problem;
//	}

	private Allergy getTestAllergy(String patientId) {
		AllergyDataLayer dao = new AllergyDataLayerOvid();
		Allergies allergies = dao.getPatientAllergies(patientId);
		Allergy allergy = allergies.get(0);
		return allergy;
	}
}
