package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.problems;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.problem.ProblemDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Problem;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;

public abstract class AbstractProblemDataLayer {

	private ProblemDataLayer dao = null;
	private Patient testPatient = null;
	private Problem expectedProblem = null;

	@Before
	public void setup() {
		dao = getDao();
		testPatient = IntegrationTestConfiguration.getTestPatient();
		expectedProblem = IntegrationTestConfiguration.getTestProblem();
	}

	abstract protected ProblemDataLayer getDao();

//	@Test
//	public void retrieveProblems() {
//		String patientId = testPatient.getId();
//		Problems problems = dao.fetchProblems(patientId);
//		assertTrue(problems.size() >= 1);
//	}
//
//	@Test
//	public void retrieveProblemsForInvalidPatient() {
//		Problems problems = dao.fetchProblems("XX");
//		assertEquals(0, problems.size());
//	}
//
//	@Test
//	public void retrieveProblemsForPatientWithoutData() {
//		String patientId = IntegrationTestConfiguration.getTestPatientWithoutData().getId();
//		Problems problems = dao.fetchProblems(patientId);
//		assertEquals("Expecting 0 problems for patient " + patientId, 0, problems.size());
//	}
//
//	private Problem retrieveTestProblem() {
//		String patientId = expectedProblem.getPatientId();
//		Problems problems = dao.fetchProblems(patientId);
//		Problem problem = problems.get(0);
//		return problem;
//	}

//	@Test
//	public void retrieveProblemsContainProblemDescription() {
//		Problem retrievedProblem = retrieveTestProblem();
//		assertEquals(expectedProblem.getDescription(), retrievedProblem.getDescription());
//	}
//
//	@Test
//	public void retrieveProblemsContainProblemId() {
//		Problem retrievedProblem = retrieveTestProblem();
//		assertEquals(expectedProblem.getProblemId(), retrievedProblem.getProblemId());
//	}
//
//	@Test
//	public void retrieveProblemsContainOnsetDate() {
//		Problem retrievedProblem = retrieveTestProblem();
//		assertEquals(expectedProblem.getOnsetDate(), retrievedProblem.getOnsetDate());
//	}

}
