package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.patient;

import static com.agilex.healthcare.testutility.AssertEx.assertEqualsIgnoreCase;
import static org.junit.Assert.assertEquals;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.PatientDataLayerOvid;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientTestHelper;

public class PatientSearchFieldTest {
	private Patient retrievedPatientViaSearch = null;
	private Patient expectedPatient = null;
	private Patient expectedInpatient;
	private Patient retrievedInpatientViaSearch;

	@Before
	public void setup() {
		PatientTestHelper.initializeOvidConnectionManager();
		expectedPatient = IntegrationTestConfiguration.getTestPatient();
		expectedInpatient = IntegrationTestConfiguration.getTestInpatient();
		retrievedPatientViaSearch = retrievePatientViaPatientSearch(expectedPatient);
		retrievedInpatientViaSearch =  retrievePatientViaPatientSearch(expectedInpatient);
	}

	private Patient retrievePatientViaPatientSearch(Patient prototype) {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setPrototype(prototype);

		PatientDataLayer datalayer = new PatientDataLayerOvid();
		Patients patients = datalayer.patientSearch(criteria);
		return patients.get(0);
	}

	@Test
	public void retrievePatientContainDisplayName() {
		assertEqualsIgnoreCase(expectedPatient.getDisplayName(), retrievedPatientViaSearch.getDisplayName());
	}

	@Test
	public void retrievePatientContainsLastName() {
		assertEqualsIgnoreCase(expectedPatient.getLastName(), retrievedPatientViaSearch.getLastName());
	}

	@Test
	public void retrievePatientContainsFirstName() {
		assertEqualsIgnoreCase(expectedPatient.getFirstName(), retrievedPatientViaSearch.getFirstName());
	}

	@Test
	public void retrievePatientContainsId() {
		assertEquals(expectedPatient.getId(), retrievedPatientViaSearch.getId());
	}

	@Test
	public void retrievePatientContainsSsn() {
		assertEquals(expectedPatient.getSsn(), retrievedPatientViaSearch.getSsn());
	}

	@Test
	public void retrievePatientContainsGender() {
		assertEquals(expectedPatient.getGender(), retrievedPatientViaSearch.getGender());
	}
	
	@Test
	public void retrievePatientContainsStatus() {
		assertEquals(expectedPatient.isInpatient(), retrievedPatientViaSearch.isInpatient());
	}
	
	@Test
	public void validateRetrievedInpatientStatusisCorrect(){
		assertEquals(expectedInpatient.isInpatient(), retrievedInpatientViaSearch.isInpatient());
	}
	
	
}
