package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.medications;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.MedicationDataLayerOvid;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.testutility.PatientTestHelper;

@Ignore
public abstract class MedicationDataLayerFieldTest {
	abstract protected Medication getExpectedMedication();

	private Medication expectedMedication = null;
	private Medication retrievedMedication = null;

	@Before
	public void setup() {
		PatientTestHelper.initializeOvidConnectionManager();
		expectedMedication = getExpectedMedication();
		retrievedMedication = loadMedication(expectedMedication);
	}

	@Test
	public void validateMedicationNameReturned() {
		assertNotNull(retrievedMedication);
	}

	@Test
	public void validateMedicationSig() {
		String expectedSig = expectedMedication.getSig();
		Medication retrievedMedication = loadMedication(expectedMedication);
		assertEquals(expectedSig, retrievedMedication.getSig());
	}

	@Test
	public void validateMedicationSource() {
		String medicationSource = expectedMedication.getMedicationSource();
		Medication retrievedMedication = loadMedication(expectedMedication);
		assertEquals(medicationSource, retrievedMedication.getMedicationSource());
	}

	private Medication loadMedication(Medication medication) {
		String patientId = medication.getPatientId();
		String drugName = medication.getDrugName();

		MedicationDataLayerOvid dao = new MedicationDataLayerOvid();
		Medications retrievedMedications = dao.getMedications(patientId, false);
		Medication retrievedMedication = null;
		for (Medication possibleMatch : retrievedMedications) {
			//System.out.println("checking " + possibleMatch.getDrugName() + "==" + drugName);
			if (possibleMatch.getDrugName().contentEquals(drugName))
				retrievedMedication = possibleMatch;
		}
		return retrievedMedication;
	}
}
