package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.allergies;

import static com.agilex.healthcare.testutility.AssertEx.assertEqualsIgnoreCase;
import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.ovid.AllergyDataLayerOvid;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientTestHelper;

public class AllergiesDataLayerTest {

	private Allergy retrievedAllergy;
	private Allergy expectedAllergy;
	private AllergyDataLayerOvid dao;

	@Before
	public void setup() {
		PatientTestHelper.initializeOvidConnectionManager();
		dao = new AllergyDataLayerOvid();
		expectedAllergy = IntegrationTestConfiguration.getTestAllergy();
		retrievedAllergy = getAllergyFromOVID(expectedAllergy);
	}

	@Test
	public void retrieveAllergies() {
		Allergies allergies = dao.getPatientAllergies(expectedAllergy.getPatientId());
		assertNotNull(allergies);
		assertTrue(allergies.size() >= 1);
	}

	@Test
	public void retrieveAllergiesForPatientWithNoAllergy() {
		Allergies allergies = dao.getPatientAllergies("XXX");
		assertEquals(0, allergies.size());
	}

	@Test
	public void retrieveAllergiesContainsSubstance() {
		assertEqualsIgnoreCase(expectedAllergy.getSubstance(), retrievedAllergy.getSubstance());
	}

	@Test
	public void retrieveAllergiesContainsPatientId() {
		assertEqualsIgnoreCase(expectedAllergy.getPatientId(), retrievedAllergy.getPatientId());
	}

	@Test
	public void retrieveAllergiesContainsReaction() {
		assertEqualsIgnoreCase(expectedAllergy.getReaction(), retrievedAllergy.getReaction());
	}

	@Test
	public void retrieveAllergiesContainsSeverity() {
		assertEqualsIgnoreCase(expectedAllergy.getSeverity(), retrievedAllergy.getSeverity());
	}

	@Test
	public void retrieveAllergiesContainsAllergyId() {
		assertEqualsIgnoreCase(expectedAllergy.getUniqueId(), retrievedAllergy.getUniqueId());
	}

	private Allergy getAllergyFromOVID(Allergy prototype) {
		Allergies allergies = dao.getPatientAllergies(prototype.getPatientId());
		Allergy allergy = null;
		for (Allergy possibleMatch : allergies) {
			if (possibleMatch.getUniqueId().contentEquals(prototype.getUniqueId()))
				allergy = possibleMatch;
		}
		return allergy;
	}

}
