package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid;

import static org.junit.Assert.assertEquals;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.testutility.PatientTestHelper;

public class PatientDispalyNameTest {
	@Before
	public void setup() {
		PatientTestHelper.initializeOvidConnectionManager();
	}

	@Test
	public void checkDisplayNameOnPatientWithoutMiddleName() {
		PatientSearchCriteria criteria = new PatientSearchCriteria();
		criteria.setSearchString("     ,Mary-Kate");
		PatientDataLayer dao = new PatientDataLayerOvid();
		Patients patients = dao.patientSearch(criteria);
		Patient patient = patients.get(0);
		assertEquals("smith", patient.getLastName().toLowerCase());
		assertEquals("smith,mary-kate", patient.getDisplayName().toLowerCase());
	}

}
