package com.agilex.healthcare.mobilehealthplatform.datalayer.ovid;

import static org.junit.Assert.assertNotNull;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.testutility.IntegrationTestConfiguration;
import com.agilex.healthcare.testutility.PatientTestHelper;

public class PatientDemographicsTest {
	private Patient expectedPatient = null;

	@Before
	public void setup() {
		PatientTestHelper.initializeOvidConnectionManager();
		expectedPatient = IntegrationTestConfiguration.getTestPatient();
	}

	@Test
	public void getDemographics() {
		PatientDataLayer dao = new PatientDataLayerOvid();
		PatientDemographics patientDemographics = dao.getDemographics(expectedPatient.getId());
		assertNotNull(patientDemographics);
	}

}
