/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package com.agilex.healthcare.mobilehealthplatform.utils;

import java.util.HashMap;

import com.agilex.healthcare.utility.NullChecker;

/**
 * 
 * @author rayj
 */
public class QueryParameterHelper {
	private static final String PARAM_DELIM = "&";
	private static final String PARAM_KEYVALUE_DELIM = "=";

	public static HashMap<String, String> getQueryMap(String query) {
		HashMap<String, String> map = new HashMap<String, String>();
		if (NullChecker.isNotNullish(query)) {
			String[] params = query.split(PARAM_DELIM);
			for (String param : params) {
				addParamToMap(map, param);
			}
		}
		return map;
	}

	private static void addParamToMap(HashMap<String, String> map, String param) {
		String[] paramParts = param.split(PARAM_KEYVALUE_DELIM);
		String name = paramParts[0];
		String value = null;
		if (paramParts.length >= 2) {
			value = paramParts[1];
		}
		map.put(name, value);
	}

}
