package com.agilex.healthcare.mobilehealthplatform.restservice.metrics;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.UriInfo;

@Path("/metrics")
public class MetricsResource {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory
			.getLog(MetricsResource.class);

	@GET
	@Path("/helloworld")
	@Produces({ "text/plain" })
	public String helloworld(@Context UriInfo u, @Context HttpHeaders headers) {
		return "helloworld";
	}

	@GET
	@Path("/sampleData")
	@Produces({ "application/json" })
	public Metric getSampleData(@Context UriInfo u,
			@Context HttpHeaders headers) {
		
		Metric metric = new Metric();
		
		int result[] = {1, 2, 3};
		
		metric.setValues(result);
		
		return metric;
	}
	
	@GET
	@Path("/applicationUsage/labViewer")
	@Produces({ "application/json" })
	public Metric getLabViewerUsage(@Context UriInfo u,
			@Context HttpHeaders headers) {
	
		String labels[] = {"July 30", "July 31", "August 1", "August 2"};
		int values[] = {20, 30, 10, 4};
		
		Metric metric = new Metric();
		metric.setLabels(labels);
		metric.setValues(values);
		
		return metric;
	}
}