package com.agilex.healthcare.mobilehealthplatform.datalayer.kmr;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;

public class PatientFactServiceTest {

	private PatientDataLayerOpenVistaFactService factService;
	private PatientSearchCriteria criteria;
	private Patient prototype;

	@Before
	public void setUp() throws Exception {
		factService = new PatientDataLayerOpenVistaFactService();
		criteria = new PatientSearchCriteria();
		prototype = new Patient();
	}

	@Test
	public void validatePatientSearchByLastNameEQPATIENT() {
		String lastName = "PATIENT";
		runPatientSearchByLastName(lastName);
	}

	private void runPatientSearchByLastName(String lastName) {
		prototype.setLastName(lastName);
		criteria.setPrototype(prototype);
		Patients patients = factService.patientSearch(criteria);
		assertTrue(patients.size() > 0);

		for (Patient patient : patients) {
			assertEquals(lastName, patient.getLastName());
		}
	}

	@Test
	public void validatePatientSearchByLastNameEQDEMO() {

		String lastName = "DEMO";
		runPatientSearchByLastName(lastName);
	}

	@Test
	public void validatePatientSearchByLastNameAndFirstName() {
		String lastName = "TESTPATIENT";
		String firstName = "ONE";
		prototype.setLastName(lastName);
		prototype.setFirstName(firstName);

		criteria.setPrototype(prototype);
		Patients patients = factService.patientSearch(criteria);
		assertTrue(patients.size() > 0);

		for (Patient patient : patients) {
			assertEquals(lastName, patient.getLastName());
			assertEquals(firstName, patient.getFirstName());
		}

	}

	@Test
	public void validateDemographicInformationIsReturned() {
		String lastName = "YOUNGER";
		String firstName = "GALLOW";
		prototype.setLastName(lastName);
		prototype.setFirstName(firstName);

		criteria.setPrototype(prototype);
		Patients patients = factService.patientSearch(criteria);
		assertTrue(patients.size() == 1);

		Patient patient = patients.get(0);

		assertEquals(lastName, patient.getLastName());
		// assertEquals(firstName, patient.getFirstName());
		// assertNotNull(patient.getMiddleInitial());
		assertNotNull(patient.getSsn());
		assertNotNull(patient.getId());
		assertNotNull(patient.getDateOfBirth());
		assertNotNull(patient.getGender());
	}

	@Ignore
	public void validatePatientSearchByFirstNameEQBABY() {

		String firstName = "BABY";
		prototype.setFirstName(firstName);
		criteria.setPrototype(prototype);
		Patients patients = factService.patientSearch(criteria);

		for (Patient patient : patients) {
			assertEquals(firstName, patient.getFirstName());
		}
	}
}
