package com.agilex.healthcare.mobilehealthplatform.datalayer.kmr;

import gov.hhs.fha.nhinc.adapter.fact.CareRecordPayloadType;
import gov.hhs.fha.nhinc.adapter.fact.FactQueryRequestType;
import gov.hhs.fha.nhinc.adapter.fact.FactQueryResponseType;
import gov.hhs.fha.nhinc.adapter.factservice.CommonDataLayerFactServiceImpl;

import java.util.UUID;

import com.agilex.healthcare.mobilehealthplatform.datalayer.problem.ProblemDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Problem;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;


public class ProblemDataLayerFactService implements ProblemDataLayer {
	private static final String MOBILE_HEALTH_PLATFORM = "Mobile Health Platform";

	@Override
	public Problems getPatientActiveProblems(String patientId) {
		FactQueryRequestType request = createRetrievePatientProblemRequest(patientId);
		invokeFactService(request);
		return null;
	}

	protected FactQueryResponseType invokeFactService(FactQueryRequestType factQueryRequest) {
		FactQueryResponseType factQueryResponse;

		try {
			factQueryResponse = CommonDataLayerFactServiceImpl.getInstance().getProblemFacts(factQueryRequest);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		return factQueryResponse;
	}

	@Override
	public Problem getPatientProblem(String patientId, String problemId) {
		// TODO Auto-generated method stub
		return null;
	}

	private FactQueryRequestType createRetrievePatientProblemRequest(String patientId) {
		FactQueryRequestType factQueryRequest = new FactQueryRequestType();
		String queryId = UUID.randomUUID().toString();
		factQueryRequest.setQueryId(queryId);
		String senderId = MOBILE_HEALTH_PLATFORM;
		factQueryRequest.setSenderId(senderId);
		String interationId = "QUPC_IN043100UV";
		factQueryRequest.setInteractionId(interationId);
		String triggerEventCode = "QUPC_TE043100UV01";
		factQueryRequest.setTriggerEventCode(triggerEventCode);
		CareRecordPayloadType payload = new CareRecordPayloadType();
		payload.setPatientId(patientId);
		payload.setCareProvisionCode("PROBLIST");
		// payload.setCareRecordStartTimePeriod("20090101");
		// payload.setCareRecordEndTimePeriod("20090630");
		factQueryRequest.setCareRecordPayload(payload);
		return factQueryRequest;
	}
}
