package com.agilex.healthcare.mobilehealthplatform.datalayer.kmr;

import gov.hhs.fha.nhinc.adapter.fact.CareRecordPayloadType;
import gov.hhs.fha.nhinc.adapter.fact.FactQueryRequestType;
import gov.hhs.fha.nhinc.adapter.fact.FactQueryResponseType;
import gov.hhs.fha.nhinc.adapter.factservice.CommonDataLayerFactServiceImpl;

import java.util.UUID;

import com.agilex.healthcare.mobilehealthplatform.domain.Medications;

public class MedicationDataLayerOpenVistaFactService  {
	private static final String MOBILE_HEALTH_PLATFORM = "Mobile Health Platform";

	public Medications getPatientMedications(String patientId) {
		FactQueryRequestType request = createRetrievePatientMedicationRequest(patientId);
		invokeFactService(request);
		return null;
	}

	protected FactQueryResponseType invokeFactService(FactQueryRequestType factQueryRequest) {
		FactQueryResponseType factQueryResponse;

		try {
			factQueryResponse = CommonDataLayerFactServiceImpl.getInstance().getMedicationFacts(factQueryRequest);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		return factQueryResponse;
	}

	private FactQueryRequestType createRetrievePatientMedicationRequest(String patientId) {
		FactQueryRequestType factQueryRequest = new FactQueryRequestType();
		String queryId = UUID.randomUUID().toString();
		factQueryRequest.setQueryId(queryId);
		String senderId = MOBILE_HEALTH_PLATFORM;
		factQueryRequest.setSenderId(senderId);
		String interationId = "QUPC_IN043100UV";
		factQueryRequest.setInteractionId(interationId);
		String triggerEventCode = "QUPC_TE043100UV01";
		factQueryRequest.setTriggerEventCode(triggerEventCode);
		CareRecordPayloadType payload = new CareRecordPayloadType();
		payload.setPatientId(patientId);
		payload.setCareProvisionCode("CURMEDLIST");
		// payload.setCareRecordStartTimePeriod("20090101");
		// payload.setCareRecordEndTimePeriod("20090630");
		factQueryRequest.setCareRecordPayload(payload);
		return factQueryRequest;
	}

	public Medications getPatientActiveMedications(String patientId) {
		// TODO Auto-generated method stub
		return null;
	}

}
