package com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.datalayer;

import static org.junit.Assert.assertNotNull;

import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.datalayer.allergy.GoogleHealthAllergyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;

public class RetrieveAllergyTest {
	private Patient getPatient() {
		PatientDataLayer datalayer = new GoogleHealthPatientDataLayer();
		Patients patients = datalayer.patientSearch(null);
		Patient patient = patients.get(0);
		return patient;
	}

	private String getAllergyUniqueId(String substanceName) {
		Patient patient = getPatient();
		AllergyDataLayer datalayer = new GoogleHealthAllergyDataLayer();
		Allergies allergies = datalayer.getPatientAllergies(patient.getId());
		String targetAllergyId = null;
		for (Allergy allergy : allergies) {
			if (allergy.getSubstance().contentEquals(substanceName))
				targetAllergyId = allergy.getUniqueId();
		}
		return targetAllergyId;
	}

	@Test
	public void retrieveAllergy() {
		String allergyId = getAllergyUniqueId("Water");
		AllergyDataLayer datalayer = new GoogleHealthAllergyDataLayer();
		Allergy allergy = datalayer.getPatientAllergy(getPatient().getId(), allergyId);
		assertNotNull(allergy);
	}
}
