package com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.datalayer;

import static org.junit.Assert.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.datalayer.allergy.GoogleHealthAllergyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.utility.DateHelper;

public class RetrieveAllergiesTest {
	private static final Log logger = LogFactory.getLog(RetrieveAllergiesTest.class);

	private Patient getPatient() {
		PatientDataLayer datalayer = new GoogleHealthPatientDataLayer();
		Patients patients = datalayer.patientSearch(null);
		Patient patient = patients.get(0);
		return patient;
	}

	@Test
	public void getAllergiesReturnsCorrectNumber() {
		Patient patient = getPatient();
		AllergyDataLayer datalayer = new GoogleHealthAllergyDataLayer();
		Allergies allergies = datalayer.getPatientAllergies(patient.getId());
		assertEquals(3, allergies.getSize());
	}

	private Allergy getAllergy(String substanceName) {
		Patient patient = getPatient();
		AllergyDataLayer datalayer = new GoogleHealthAllergyDataLayer();
		Allergies allergies = datalayer.getPatientAllergies(patient.getId());
		Allergy targetAllergy = null;
		for (Allergy allergy : allergies) {
			logger.debug("allergy: " + allergy.getSubstance());
			if (allergy.getSubstance().contentEquals(substanceName))
				targetAllergy = allergy;
		}
		return targetAllergy;
	}

	@Test
	public void ensureWaterAllergyReturned() {
		Allergy waterAllergy = getAllergy("Water");
		assertNotNull("allergy not found", waterAllergy);
	}

	@Test
	public void ensureWaterAllergyContainsReaction() {
		Allergy waterAllergy = getAllergy("Water");
		assertEquals("SEVERE", waterAllergy.getReaction());
	}

	@Test
	public void ensureWaterAllergyIsActive() {
		Allergy allergy = getAllergy("Water");
		assertEquals(true, allergy.isActive());
	}

	@Test
	public void verifyOnsetDate() {
		Allergy allergy = getAllergy("Water");
		assertEquals(DateHelper.parseDate("01/01/2010"), allergy.getOnsetDate());
	}

	@Test
	public void verifyResolutionDate() {
		Allergy allergy = getAllergy("Peanut");
		assertEquals(DateHelper.parseDate("01/01/1985"), allergy.getResolutionDate());
	}
	@Test
	public void verifyNullResolutionDate() {
		Allergy allergy = getAllergy("Water");
		assertEquals(null, allergy.getResolutionDate());
	}

	@Test
	public void ensurePeanutAllergyIsInactive() {
		Allergy allergy = getAllergy("Peanut");
		assertEquals(false, allergy.isActive());
	}
}
