package com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.datalayer;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNotNull;

import org.junit.Before;
import org.junit.Test;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;

public class PatientSearchTest {
	private Patient patient;

	@Before
	public void setup() {
		PatientDataLayer datalayer = new GoogleHealthPatientDataLayer();
		Patients patients = datalayer.patientSearch(null);
		patient = patients.get(0);
	}

	@Test
	public void patientSearchReturnsProfile() {
		PatientDataLayer datalayer = new GoogleHealthPatientDataLayer();
		Patients patients = datalayer.patientSearch(null);
		assertNotNull(patients);
		assertEquals(1, patients.getSize());
	}

	@Test
	public void patientContainsEmailAddressAsName() {
		assertEquals("zztest.patient01.75@gmail.com", patient.getDisplayName());
	}

	@Test
	public void patientContainsGender() {
		assertEquals("Male", patient.getGender());
	}

//	@Test
//	public void patientContainsDob() {
//		assertEquals(DateHelper.parseDate("05/05/1975"), patient.getDateOfBirth());
//	}
}
