package agilex.google;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;

import org.junit.Test;

import com.google.gdata.client.health.HealthService;
import com.google.gdata.data.Entry;
import com.google.gdata.data.Feed;
import com.google.gdata.data.TextContent;
import com.google.gdata.data.health.ProfileEntry;
import com.google.gdata.data.health.ProfileFeed;
import com.google.gdata.util.ServiceException;

public class PlayTest {

	private static final String FEED_BASE_PATH = "https://www.google.com/health/feeds/";
	private static final String PROFILE_FEED_PATH = FEED_BASE_PATH + "profile/";
//	private static final String REGISTER_FEED_PATH = FEED_BASE_PATH + "register/";
	private static final String PROFILE_LIST_URL_PATH = PROFILE_FEED_PATH + "list";

	@Test
	public void auth() throws MalformedURLException, IOException, ServiceException {
		HealthService healthservice = new com.google.gdata.client.health.HealthService("agilex-mobilehealthplatorm-1.0");
		healthservice.setUserCredentials("zztest.patient01.75@gmail.com", "agilexadmin99$");

		Feed profileListFeed = healthservice.getFeed(new URL(PROFILE_LIST_URL_PATH), Feed.class);
		for (Entry profileListEntry : profileListFeed.getEntries()) {
			String profileId = ((TextContent) profileListEntry.getContent()).getContent().getPlainText();
			System.out.println("profileId=" + profileId);
			ProfileFeed profileFeed = healthservice.getFeed(new URL(PROFILE_FEED_PATH + "ui/" + profileId), ProfileFeed.class);
			for (ProfileEntry entry : profileFeed.getEntries()) {
				System.out.println(entry.getContinuityOfCareRecord().getXmlBlob().getBlob());
			}
		}

		// System.out.println("CCR records for profile id: " + profileId);
		// ProfileFeed feed = service.getFeed(new URL(PROFILE_FEED_PATH + "ui/"
		// + profileId), ProfileFeed.class);
		// for (ProfileEntry entry : feed.getEntries()) {
		// out.println(entry.getContinuityOfCareRecord().getXmlBlob().getBlob());
		// }

	}

}
