package com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.datalayer.problems;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.GdataHelper;
import com.agilex.healthcare.mobilehealthplatform.datalayer.problem.ProblemDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Problem;
import com.agilex.healthcare.mobilehealthplatform.domain.Problems;

public class GoogleHealthProblemDataLayer implements ProblemDataLayer {
	private static final String PROBLEMS_XPATH = "//Problems/Problem";
	private static final Log logger = LogFactory.getLog(GoogleHealthProblemDataLayer.class);

	@Override
	public Problems getPatientActiveProblems(String patientId) {
		logger.debug("retrieving problems for patient/profile " + patientId);
		NodeList problemNodes = GdataHelper.getCcrElements(patientId, PROBLEMS_XPATH);
		Problems problems = new Problems();
		for (int i = 0; i < problemNodes.getLength(); i++) {
			Node problemNode = problemNodes.item(i);
			Problem problem = createProblemFromNode(patientId, problemNode);
			problems.add(problem);
		}

		logger.debug("returning " + problems.getSize() + " problem(s)");
		return problems;
	}

	private Problem createProblemFromNode(String patientId, Node problemNode) {
		logger.debug("procesing problem node");
		Problem problem = new Problem();
		ProblemParser parser = new ProblemParser(problemNode);
		problem.setActive(parser.extractActiveStatus());
		// problem.setComments(comments)
		problem.setDescription(parser.extractDescription());
		problem.setOnsetDate( parser.extractOnsetDate() );
		problem.setResolutionDate( parser.extractResolutionDate()  );
		problem.setPatientId(patientId);
		problem.setProblemId( parser.extractObjectId() );
		return problem;
	}

	@Override
	public Problem getPatientProblem(String patientId, String problemId) {
		return null;
	}
}
