package com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.datalayer.lab;

import java.util.Date;

import org.w3c.dom.Node;

import com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.CcrDataElementParser;

public class LabResultParser extends CcrDataElementParser {

	private static final String TEST_RESULT_VALUE_XPATH = "TestResult/Value";
	private static final String TESTNAME_XPATH = "Test/Description/Text";
	private static final String DEFAULT_CODING_SYSTEM = "Google";
	private static final String RESULTED_DATE_XPATH = "DateTime[Type/Text='Collection start date']/ExactDateTime";
	private static final String TEST_RESULT_VALUE_UNITS_XPATH = "TestResult/Units/Unit";

	public LabResultParser(Node dataElement) {
		super(dataElement);
	}

	public Date extractResultedDate() {
		return this.extractDateValue(RESULTED_DATE_XPATH);
	}

	public String extractTestId() {
		return extractTestId(DEFAULT_CODING_SYSTEM);
	}

	public String extractTestId(String codingSystem) {
		String xpath = "Test/Description/Code[CodingSystem='" + codingSystem + "']/Value";
		return this.extractStringValue(xpath);
	}

	public String extractTestName() {
		return this.extractStringValue(TESTNAME_XPATH);
	}

	public String extractResultValue() {
		return this.extractStringValue(TEST_RESULT_VALUE_XPATH);
	}

	public String extractResultValueUnits() {
		return this.extractStringValue(TEST_RESULT_VALUE_UNITS_XPATH);
	}
}
