package com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.datalayer.lab;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.GdataHelper;
import com.agilex.healthcare.mobilehealthplatform.datalayer.lab.LabDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.domain.LabTestGroups;

public class GoogleHealthLabDataLayer implements LabDataLayer {
	private static final String RESULTS_XPATH = "//Results/Result";
	private static final Log logger = LogFactory.getLog(GoogleHealthLabDataLayer.class);

	@Override
	public LabResults getLabResults(String patientId, Date startDate, Date endDate) {
		NodeList resultNodes = GdataHelper.getCcrElements(patientId, RESULTS_XPATH);
		logger.debug("result nodes count " + resultNodes.getLength());
		LabResults results = new LabResults();
		for (int i = 0; i < resultNodes.getLength(); i++) {
			Node resultNode = resultNodes.item(i);
			LabResult labResult = createLabResultFromNode(resultNode);
			results.add(labResult);
		}

		logger.debug("returning " + results.getSize() + " lab results(s)");
		return results;
	}

	private LabResult createLabResultFromNode(Node resultNode) {
		logger.debug("procesing result node");
		LabResult labResult = new LabResult();
		LabResultParser parser = new LabResultParser(resultNode);
		labResult.setAccessionNumber(parser.extractObjectId());
		// labResult.setComment( "" ) ;
		// labResult.getOrderId()
		labResult.setResultedDate(parser.extractResultedDate());
		// labResult.getStatus()
		labResult.setTestId(parser.extractTestId("Google"));
		labResult.setTestname(parser.extractTestName());
		labResult.setValue(parser.extractResultValue());
		labResult.setValueUnits(parser.extractResultValueUnits());
		return labResult;
	}

	@Override
	public LabTestGroups lookupLabGroupsByTestId(String labTestId) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Map<String, LabTestGroups> lookupLabGroupsByTestIds(List<String> labTestIds) {
		// TODO Auto-generated method stub
		return null;
	}
}
