package com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.datalayer.allergy;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.agilex.healthcare.mobilehealthplatform.datalayer.allergy.AllergyDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.GdataHelper;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergies;
import com.agilex.healthcare.mobilehealthplatform.domain.Allergy;

public class GoogleHealthAllergyDataLayer implements AllergyDataLayer {
	private static final String ALLERGIES_XPATH = "//Alerts/Alert[Type/Text/text()='Allergy']";
	private static final String ALLERGRY_NODETITLE = "Alert";
	private static final Log logger = LogFactory.getLog(GoogleHealthAllergyDataLayer.class);

	@Override
	public Allergies getPatientAllergies(String patientId) {
		logger.debug("retrieving allergies for patient/profile " + patientId);

		NodeList allergyNodes = GdataHelper.getCcrElements(patientId, ALLERGIES_XPATH);
		logger.debug("allergy node count " + allergyNodes.getLength());
		Allergies allergies = new Allergies();
		for (int i = 0; i < allergyNodes.getLength(); i++) {
			logger.debug("procesing allergy node");
			Node allergyNode = allergyNodes.item(i);
			Allergy allergy = createAllergyFromNode(allergyNode);
			allergies.add(allergy);
		}

		logger.debug("returning " + allergies.getSize() + " allergy(s)");
		return allergies;
	}

	private Allergy createAllergyFromNode(Node allergyNode) {
		Allergy allergy = null;
		if (allergyNode != null) {
			AllergyParser parser = new AllergyParser(allergyNode);
			allergy = new Allergy();
			allergy.setUniqueId(parser.extractObjectId());
			allergy.setSubstance(parser.extractDescription());
			allergy.setReaction(parser.extractReactionSeverity());
			allergy.setActive(parser.extractActiveStatus());
			allergy.setOnsetDate(parser.extractOnsetDate());
			allergy.setResolutionDate(parser.extractResolutionDate());
		}
		return allergy;
	}

	@Override
	public Allergy getPatientAllergy(String patientId, String allergyId) {
		Node allergyNode = GdataHelper.getCcrNode(patientId, ALLERGRY_NODETITLE, allergyId);
		Allergy allergy = createAllergyFromNode(allergyNode);
		return allergy;
	}

}
