package com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.datalayer;

import java.net.URL;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

import com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.GdataHelper;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.domain.DOBDate;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientDemographics;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.XpathHelper;
import com.google.gdata.client.health.HealthService;
import com.google.gdata.data.Entry;
import com.google.gdata.data.Feed;
import com.google.gdata.data.TextContent;

public class GoogleHealthPatientDataLayer implements PatientDataLayer {
	private static final Log logger = LogFactory.getLog(GoogleHealthPatientDataLayer.class);

	private static final String FEED_BASE_PATH = "https://www.google.com/health/feeds/";
	private static final String PROFILE_FEED_PATH = FEED_BASE_PATH + "profile/";
//	private static final String REGISTER_FEED_PATH = FEED_BASE_PATH + "register/";
	private static final String PROFILE_LIST_URL_PATH = PROFILE_FEED_PATH + "list";

	@Override
	public Patients patientSearch(PatientSearchCriteria criteria) {
		Patients patients = new Patients();

		try {
			logger.debug("retrieve all patient profiles");
			HealthService service = GdataHelper.getGoogleHealthService();
			Feed profileListFeed = service.getFeed(new URL(PROFILE_LIST_URL_PATH), Feed.class);
			for (Entry profileListEntry : profileListFeed.getEntries()) {
				String profileId = ((TextContent) profileListEntry.getContent()).getContent().getPlainText();
				logger.debug("profile:" + profileId);
				logger.debug("id:" + profileListEntry.getId());
				 Document demographics = GdataHelper.getDemographicsFeedAsXml(service, profileId);
				Patient patient = convertFeedToPatient(demographics);
				patient.setId(profileId);
				patients.add(patient);
			}

		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		logger.debug("returning " + patients.getSize() + " patient(s)");
		return patients;
	}

	private Patient convertFeedToPatient(Node demographics) {
		Patient patient = new Patient();
		String actorId = XpathHelper.getString(demographics, "/doc/Actors/Actor/Source/Actor/ActorID");
		patient.setDisplayName(actorId);
		String sDob = XpathHelper.getString(demographics, "/doc/Actors/Actor/Person/DateOfBirth/ExactDateTime");
		Date dob = DateHelper.parse(sDob, "yyyy-MM-dd");
		// patient.setDateOfBirth(dob);

		DOBDate dateOfBirth = new DOBDate(dob);
		patient.setDateOfBirth(dateOfBirth);

		String gender = XpathHelper.getString(demographics, "/doc/Actors/Actor/Person/Gender/Text");
		patient.setGender(gender);
		return patient;
	}

	@Override
	public PatientDemographics getDemographics(String patientId) {
		PatientDemographics demographics = new PatientDemographics();
		return demographics;
	}

	@Override
	public Patient getPatient(String patientId) {
		Patient patient = null;
		try {
			HealthService service = GdataHelper.getGoogleHealthService();
			Document demographicsNode = GdataHelper.getDemographicsFeedAsXml(service, patientId);
			patient = convertFeedToPatient(demographicsNode);
		} catch (Exception ex) {
			throw new RuntimeException(ex);
		}
		return patient;
	}
}
