package com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.datalayer;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.GdataHelper;
import com.agilex.healthcare.mobilehealthplatform.datalayer.medication.MedicationDataLayer;
import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.XpathHelper;
import com.google.gdata.client.health.HealthService;
import com.google.gdata.util.AuthenticationException;

public class GoogleHealthMedicationDataLayer implements MedicationDataLayer {
	private static final Log logger = LogFactory.getLog(GoogleHealthMedicationDataLayer.class);

	@Override
	public Medications getMedications(String patientId, boolean activeOnly) {
		logger.debug("retrieving medications for patient/profile " + patientId);

		HealthService service;
		try {
			service = GdataHelper.getGoogleHealthService();
		} catch (AuthenticationException e) {
			throw new RuntimeException(e);
		}

		logger.debug("begin retrieve of CCR for " + patientId);
		Document ccr = GdataHelper.getCcrAsXml(service, patientId);
		NodeList medNodes = XpathHelper.getNodeList(ccr, "//Medications/Medication");
		logger.debug("medication nodes count " + medNodes.getLength());
		Medications medications = new Medications();
		for (int i = 0; i < medNodes.getLength(); i++) {
			logger.debug("procesing medication node");
			Node medNode = medNodes.item(i);
			Medication medication = new Medication();
			medication.setDrugName(XpathHelper.getString(medNode, "Product/ProductName/Text"));
			medication.setEndDate(DateHelper.parse(XpathHelper.getString(medNode, "DateTime[Type/Text='Stop date']/ExactDateTime"), "yyyy-MM"));
			medication.setMedicationSource("OUTPATIENT");
			medication.setOrderNumber(XpathHelper.getString(medNode, "CCRDataObjectID"));
			medication.setStartDate(DateHelper.parse(XpathHelper.getString(medNode, "DateTime[Type/Text='Start date']/ExactDateTime"), "yyyy-MM"));
			boolean active = medication.getEndDate() == null;
			medication.setActive(active);
			if (!activeOnly || active)
				medications.add(medication);
		}

		logger.debug("returning " + medications.getSize() + " medication(s)");
		return medications;
	}

	@Override
	public Medication getMedicationLite(String patientId, String orderNumber) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Medication getMedicationDetail(String patientId, String orderNumber) {
		// TODO Auto-generated method stub
		return null;
	}

}
