package com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.datalayer;

import java.io.InputStream;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.agilex.healthcare.mobilehealthplatform.datalayer.document.DocumentDataLayer;
import com.agilex.healthcare.mobilehealthplatform.datalayer.document.DocumentQueryParameters;
import com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth.GdataHelper;
import com.agilex.healthcare.mobilehealthplatform.domain.nhin.Document;
import com.agilex.healthcare.mobilehealthplatform.domain.nhin.DocumentBody;
import com.agilex.healthcare.mobilehealthplatform.domain.nhin.Documents;
import com.agilex.healthcare.utility.StreamHelper;
import com.agilex.healthcare.utility.XmlHelper;
import com.agilex.healthcare.utility.XpathHelper;
import com.google.gdata.client.health.HealthService;
import com.google.gdata.util.AuthenticationException;

public class GoogleHealthDocumentDataLayer implements DocumentDataLayer {
	private static final Log logger = LogFactory.getLog(GoogleHealthDocumentDataLayer.class);

	@Override
	public Document RetrieveDocumentMetadata(String homeCommunityId, String registryId, String documentUniqueId) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public DocumentBody RetrieveDocumentBody(String homeCommunityId, String registryId, String documentUniqueId) {
		DocumentQueryParameters params = new DocumentQueryParameters();
		params.setHomeCommunityId(homeCommunityId);
		params.setRepositoryId(registryId);
		Documents documents = DocumentSearch(params);
		DocumentBody body = null;
		for (Document document : documents) {
			if (document.getDocumentUniqueId().contentEquals(documentUniqueId)) {
				body = document.getBody();
			}
		}
		return body;
	}

	@Override
	public Documents DocumentSearch(DocumentQueryParameters params) {
		String patientId;
		if (params.getPatient() == null) {
			patientId = params.getRepositoryId();
		} else {
			patientId = params.getPatient().getPatientId();
		}

		Documents documents = new Documents();
		logger.debug("retrieving documents for patient/profile " + patientId + ".  For now this will be a CCR document only");

		HealthService service;
		try {
			service = GdataHelper.getGoogleHealthService();
		} catch (AuthenticationException e) {
			throw new RuntimeException(e);
		}

		logger.debug("begin retrieve of CCR for " + patientId);
		org.w3c.dom.Document ccr = GdataHelper.getCcrAsXml(service, patientId);

		String homeCommunityId = "1";
		String repositoryId = patientId;
		String documentUniqueId = XpathHelper.getString(ccr, "CCRDocumentObjectID");

		Document document = new Document(homeCommunityId, repositoryId, documentUniqueId);
		document.setClassCode("CCR");
		document.setDocumentTitle("CCR");
		document.setPatientIdentifier(params.getPatient());
		DocumentBody body = new DocumentBody();
		body.setMimeType("application/xml");

		String ccrAsString = XmlHelper.xmlToString(ccr);
		InputStream ccrAsStream = StreamHelper.stringToStream(ccrAsString);
		body.setBody(ccrAsStream);
		document.setBody(body);
		documents.add(document);

		logger.debug("returning " + documents.getSize() + " document(s)");
		return documents;
	}

}
