package com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth;

import java.net.URL;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.agilex.healthcare.utility.XmlHelper;
import com.agilex.healthcare.utility.XpathHelper;
import com.google.gdata.client.health.HealthService;
import com.google.gdata.data.health.ContinuityOfCareRecord;
import com.google.gdata.data.health.ProfileEntry;
import com.google.gdata.data.health.ProfileFeed;
import com.google.gdata.util.AuthenticationException;

public class GdataHelper {
	private static final Log logger = LogFactory.getLog(GdataHelper.class);

	private static final String mhp = "agilex-mobilehealthplatorm-1.0";
	private static final String password = "agilexadmin99$";
	private static final String username = "zztest.patient01.75@gmail.com";

	private static final String FEED_BASE_PATH = "https://www.google.com/health/feeds/";
	private static final String PROFILE_FEED_PATH = FEED_BASE_PATH + "profile/";
//	private static final String REGISTER_FEED_PATH = FEED_BASE_PATH + "register/";
//	private static final String PROFILE_LIST_URL_PATH = PROFILE_FEED_PATH + "list";

	public static HealthService getGoogleHealthService() throws AuthenticationException {
		logger.debug(String.format("begin google health logon [%s][%s]", username, mhp));
		HealthService service = new com.google.gdata.client.health.HealthService(mhp);
		service.setUserCredentials(username, password);
		return service;
	}

	public static Node getCcrNode(String patientId, String elementNodeTitle, String dataObjectID) {
		Document ccr = getCcrAsXml(patientId);
		String xpath = "//" + elementNodeTitle + "[CCRDataObjectID='" + dataObjectID + "']";
		Node singleNode = XpathHelper.getNode(ccr, xpath);

		XmlHelper.xmlToString(singleNode);
		return singleNode;

	}

	public static NodeList getCcrElements(String patientId, String elementXpath) {
		logger.debug(String.format("retrieving ccr elements [patientid=%s][elementXpath=%s]", patientId, elementXpath));

		Node ccr = getCcrAsXml(patientId);
		NodeList nodeList = XpathHelper.getNodeList(ccr, elementXpath);
		logger.debug(String.format("returning %s node(s) for xpath=%s", nodeList.getLength(), elementXpath));
		return nodeList;
	}

	public static Document getCcrAsXml(String patientId) {
		HealthService service;
		try {
			service = GdataHelper.getGoogleHealthService();
		} catch (AuthenticationException e) {
			throw new RuntimeException(e);
		}

		logger.debug("begin retrieve of CCR for " + patientId);
		Document ccr = GdataHelper.getCcrAsXml(service, patientId);
		return ccr;
	}

	public static Document getCcrAsXml(HealthService service, String profileId) {
		ContinuityOfCareRecord ccr = getCcr(service, profileId);
		Document xml = null;
		if (ccr != null) {
			String s = ccr.getXmlBlob().getBlob();
			logger.debug("ccr:" + s);
			s = "<doc>" + s + "</doc>";
			xml = XmlHelper.loadXml(s);
		}
		return xml;
	}

	public static ContinuityOfCareRecord getCcr(HealthService service, String profileId) {
		ProfileFeed profileFeed;
		try {
			profileFeed = service.getFeed(new URL(PROFILE_FEED_PATH + "ui/" + profileId + "?digest=true"), ProfileFeed.class);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		ContinuityOfCareRecord ccr = null;
		if (profileFeed.getEntries().size() >= 1) {
			for (ProfileEntry entry : profileFeed.getEntries()) {
				logger.debug("entry:" + entry.getEdited());
				ccr = entry.getContinuityOfCareRecord();
			}
			ccr = profileFeed.getEntries().get(0).getContinuityOfCareRecord();
		}

		return ccr;
	}

	public static Document getDemographicsFeedAsXml(HealthService service, String profileId) {
		ContinuityOfCareRecord ccr = getDemographicsFeed(service, profileId);
		Document xml = null;
		if (ccr != null) {
			String s = ccr.getXmlBlob().getBlob();
			logger.debug("demographics:" + s);
			s = "<doc>" + s + "</doc>";
			xml = XmlHelper.loadXml(s);
		}
		return xml;
	}

	public static ContinuityOfCareRecord getDemographicsFeed(HealthService service, String profileId) {
		ProfileFeed profileFeed;
		try {
			profileFeed = service.getFeed(new URL(PROFILE_FEED_PATH + "ui/" + profileId + "/-/demographics?digest=true"), ProfileFeed.class);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}

		ContinuityOfCareRecord ccr = null;
		if (profileFeed.getEntries().size() >= 1) {
			ccr = profileFeed.getEntries().get(0).getContinuityOfCareRecord();
		}

		return ccr;
	}

}
