package com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth;

import java.net.URI;
import java.net.URISyntaxException;

import javax.ws.rs.core.MultivaluedMap;

import com.agilex.healthcare.utility.StreamHelper;
import com.google.gdata.util.AuthenticationException;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;

//consider this a prototype example
public class ClientLogon {
	public void logon() throws URISyntaxException, AuthenticationException {
		Client jerseyclient = new com.sun.jersey.api.client.Client();
		String url = "https://www.google.com/accounts/ClientLogin";
		URI uri = new URI(url);
		WebResource resource = jerseyclient.resource(uri);

		MultivaluedMap<String, String> formData = new MultivaluedMapImpl();
		formData.add("accountType", "GOOGLE");
		formData.add("Email", "");
		formData.add("Passwd", "");
		formData.add("service", "health");
		formData.add("source", "agilex-mobilehealthplatorm-1.0");
		ClientResponse response = resource.type("application/x-www-form-urlencoded").post(ClientResponse.class, formData);
		String result = StreamHelper.streamToString(response.getEntityInputStream());
		if (response.getStatus() == 200) {
			System.out.println("success");
			System.out.println("result: " + result);
		} else {
			throw new AuthenticationException(String.format("authentication failed [%s][%s]", response.getStatus(), result));
		}

	}
}