package com.agilex.healthcare.mobilehealthplatform.datalayer.googlehealth;

import java.util.Date;

import org.w3c.dom.Node;

import com.agilex.healthcare.utility.DateHelper;
import com.agilex.healthcare.utility.NullChecker;
import com.agilex.healthcare.utility.XpathHelper;

public class CcrDataElementParser {
	private static final String CCR_DATA_OBJECT_ID_XPATH = "CCRDataObjectID";
	private static final String INACTIVE_STATUS = "inactive";
	private static final String ACTIVE_STATUS = "active";
	private static final String STATUS_TEXT = "Status/Text";
	private static final String RESOLUTION_DATE_XPATH = "DateTime[Type/Text='Stop date']/ExactDateTime";
	private static final String ONSET_DATE_XPATH = "DateTime[Type/Text='Start date']/ExactDateTime";
	private static final boolean DEFAULT_ACTIVE_STATUS = true;
	private static final String DESCRIPTION_XPATH = "Description/Text";
	private Node dataElement;

	public CcrDataElementParser(Node dataElement) {
		this.dataElement = dataElement;
	}

	public Date extractOnsetDate() {
		final String xpath = ONSET_DATE_XPATH;
		return extractDateValue(xpath);
	}

	public Date extractResolutionDate() {
		final String xpath = RESOLUTION_DATE_XPATH;
		return extractDateValue(xpath);
	}

	public String extractStringValue(final String xpath) {
		return XpathHelper.getString(dataElement, xpath);
	}

	public Date extractDateValue(final String xpath) {
		String dateText = extractStringValue(xpath);
		Date date = null;
		if (NullChecker.isNotNullish(dateText)) {
			date = null;
			try {
				date = DateHelper.parse(dateText, "yyyy-MM");
			} catch (Exception e) {
			}
			if (date == null) {
				try {
					date = DateHelper.parse(dateText, "yyyy");
				} catch (Exception e) {
				}
			}
		}
		return date;
	}

	public String extractDescription() {
		return extractStringValue(DESCRIPTION_XPATH);
	}

	public String extractObjectId() {
		return extractStringValue(CCR_DATA_OBJECT_ID_XPATH);
	}

	public boolean extractActiveStatus() {
		String activeText = extractStringValue(STATUS_TEXT);
		boolean active = DEFAULT_ACTIVE_STATUS;
		if (NullChecker.isNotNullish(activeText)) {
			activeText = activeText.toLowerCase();
			if (activeText.contentEquals(ACTIVE_STATUS)) {
				active = true;
			} else if (activeText.contentEquals(INACTIVE_STATUS)) {
				active = false;
			}
		}
		return active;

	}

}
