package com.agilex.healthcare.mobilehealthplatform;

import java.security.Principal;

import org.apache.catalina.realm.RealmBase;

public class CustomRealm2 extends RealmBase {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(CustomRealm2.class);

	public CustomRealm2() {
		logger.info("CustomRealm2 initialized");
	}

	@Override
	public Principal authenticate(String username, String credentials) {
		logger.info(String.format("authentication [%s][%s]", username, credentials));
//		if (username.equalsIgnoreCase("mhp2"))
			return new CustomPrincipal(username);
//		else
//			return null;
	};

	@Override
	protected String getName() {
		logger.info("get name");
		return "mhp-realm";
	}

	@Override
	protected String getPassword(String paramString) {
		logger.info("get password");
		return null;
	}

	@Override
	protected Principal getPrincipal(String paramString) {
		logger.info("get principal");
		return null;
	}

	@Override
	public boolean hasResourcePermission(org.apache.catalina.connector.Request request, org.apache.catalina.connector.Response response, org.apache.catalina.deploy.SecurityConstraint[] constraints,
			org.apache.catalina.Context context) throws java.io.IOException {
		logger.info("hasResourcePermission");
		return true;
	};

	class CustomPrincipal implements Principal {
		private final String name;

		public CustomPrincipal(String name) {
			this.name = name;
		}

		public String getName() {
			return name;
		}

		public String toString() {
			return getName();
		}
	}

}
