package com.agilex.healthcare.mobilehealthplatform;

import java.security.Principal;

import org.apache.catalina.realm.RealmBase;

public class CustomRealm extends RealmBase {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(CustomRealm.class);

	public CustomRealm() {
		logger.info("CustomAuthentication initialized");
	}

	@Override
	protected String getPassword(String username) {
		logger.info("get password invoked for user " + username);
		return "password";
	}

	@Override
	protected Principal getPrincipal(String username) {
		logger.info("get password principal for user " + username);
		return new CustomPrincipal(username);
	}

	@Override
	public boolean hasRole(Principal principal, String role) {
		return true;
	}

	class CustomPrincipal implements Principal {
		private final String name;

		public CustomPrincipal(String name) {
			this.name = name;
		}

		public String getName() {
			return name;
		}

		public String toString() {
			return getName();
		}

	}

	@Override
	protected String getName() {
		logger.info("getname invoked");
		return null;
	}
}
