package com.agilex.healthcare.mobilehealthplatform.patient;


import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.PatientTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import com.agilex.healthcare.mobilehealthplatform.mdws.translator.PatientTranslator;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;

public class PatientSearchTests {

    PatientTranslator translator = new PatientTranslator();

    PatientTO to = new PatientTO();

    @Before
    public void before() {
        to.setPatientName("SMITH,ALFRED ARTHUR JR");
    }

    @Test
    public void validatePatientNameTranslation() {
        Patient p = new Patient();
        translator.tryToSetPatientNames(p, to);

        Assert.assertEquals("SMITH", p.getLastName());
        Assert.assertEquals("ALFRED", p.getFirstName());
    }



//    PatientDataLayerMdws dl = new PatientDataLayerMdws(new MdwsConfiguration());
//
//    PatientSearchCriteria criteria = null;
//    Patients patients = new Patients();
//
//    @Before
//    public void before() {
//        criteria = new PatientSearchCriteria();
//        criteria.setSearchString("smith,adams");
//
//        Patients patients = new Patients();
//        Patient patient = new Patient();
//        patient.set
//    }


}
