package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import org.junit.*;

public class FacilityTranslatorTest {

	@Test
	public void validateSiteNameAlterations() {
		String siteName = "(358) Manila, Philippines";
		
		FacilityTranslator translator = new FacilityTranslator();
		Assert.assertEquals("Manila, Philippines", translator.alterFacilityName(siteName));
	}
	
	@Test
	public void validateSiteNameAlterationsWithTrim() {
		String siteName = " (358) Manila, Philippines";
		
		FacilityTranslator translator = new FacilityTranslator();
		Assert.assertEquals("Manila, Philippines", translator.alterFacilityName(siteName));
	}
	
	@Test
	public void validateSiteNameThatShouldNotBeAltered() {
		String siteName = "Washington";
		
		FacilityTranslator translator = new FacilityTranslator();
		Assert.assertEquals("Washington", translator.alterFacilityName(siteName));
	}
	
}
