package com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer;

import static org.junit.Assert.assertEquals;

import org.junit.Test;

public class MdwsConfigurationHelperTest {
	MdwsConfigurationHelper helper = new MdwsConfigurationHelper();

	@Test
	public void testExtractSiteCodeWhenAAisICN() {
		assertEquals("204", helper.extractSiteCodeFromAssigningAuthority("ICN"));
	}

	public void testExtractSiteCodeWhenAAisicn() {
		assertEquals("204", helper.extractSiteCodeFromAssigningAuthority("icn"));
	}
	
	public void testExtractSiteCodeWhenAAisDFN688() {
		assertEquals("688", helper.extractSiteCodeFromAssigningAuthority("DFN-688"));
	}

	public void testExtractSiteCodeWhenAAisdfn688() {
		assertEquals("688", helper.extractSiteCodeFromAssigningAuthority("dfn-688"));
	}

	public void testExtractSiteCodeWhenAAisEDIPI() {
		assertEquals("", helper.extractSiteCodeFromAssigningAuthority("EDIPI"));
	}

	public void testExtractSiteTypeWhenAAisICN(){
		assertEquals("ICN", helper.extractSiteTypeFromAssigningAuthority("ICN"));
	}

	public void testExtractSiteTypeWhenAAisDFN688(){
		assertEquals("VISTA", helper.extractSiteTypeFromAssigningAuthority("DFN-688"));
	}
}
