package com.agilex.healthcare.mobilehealthplatform.datalayer.patient;

import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientDataLayerMdws;
import com.agilex.healthcare.mobilehealthplatform.datalayer.patient.PatientSearchCriteria;
import com.agilex.healthcare.mobilehealthplatform.domain.Patient;
import com.agilex.healthcare.mobilehealthplatform.domain.Patients;
import com.agilex.healthcare.mobilehealthplatform.mdws.soapconsumer.MdwsConfiguration;
import junit.framework.TestCase;
import org.junit.*;

/**
 * Created by
 * User: ralph
 * Date: 11/24/14
 * Time: 9:56 AM
 */
public class PatientDataLayerMdwsTest extends TestCase {

    @Test
    public void  testApplyPostNameFiltering() {
        PatientDataLayerMdws      patientDataLayer = new PatientDataLayerMdws(new MdwsConfiguration());
        PatientSearchCriteria     patientSearchCriteria = new PatientSearchCriteria();
        Patients                  patientList = new Patients();
        Patients                  results;
        Patient                   prototype = new Patient();

        patientSearchCriteria.setPrototype(prototype);
        prototype.setFirstName("Frederick");
        prototype.setLastName("Throckmorton");
        prototype.setMiddleName("P III");

        for(int x = 0; x < 5; x++) {
            Patient p;

            p = new Patient();
            p.setFirstName("FirstName" + x);
            p.setLastName("LastName" + x);
            if(x > 0 && x % 2 == 0) {
                p.setMiddleName("MiddleName Jr.");
            }
            else {
                p.setMiddleName("MiddleName");
            }
            patientList.add(p);
        }

        patientList.add(prototype);

        results = patientDataLayer.applyNamePostFiltering(patientSearchCriteria, patientList);

        assertNotNull("patientDataLayer.applyNamePostFiltering() returned a null object", results);
        assertEquals("patientDataLayer.applyNamePostFiltering() returned the wrong number of patients.",
                     1, results.size());
    }

}
