package com.agilex.healthcare.mobilehealthplatform.security;

import java.net.URL;
import java.util.Map;

import javax.xml.ws.BindingProvider;

import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.transport.http.Cookie;
import org.apache.cxf.transport.http.HTTPConduit;

import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseException;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.DataSourceArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.EmrSvc;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.EmrSvcSoap;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserSecurityKeyArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserTO;

public class VistaAuthenticator implements AppAuthenticator {

	private String baseEmrServiceUrl;
	private String emrSvcName;
	private final String emrSvcUrl;
	private final URL emrSvcWsdlUrl;

	public VistaAuthenticator(String baseEmrServiceUrl, String emrSvcName) {
		this.baseEmrServiceUrl = baseEmrServiceUrl;
		this.emrSvcName = emrSvcName;
		this.emrSvcUrl = constructEmrSvcUrl();
		this.emrSvcWsdlUrl = constructEmrSvclWsdlUrl();
	}

	@Override
	public MhpUser authenticate(String accessCode, String verifyCode, String siteCode) throws Exception {
		EmrSvcSoap emrSvcPort = getEmrSvcPort();
		emrSvcPort = connectToVistA(emrSvcPort, siteCode);
		UserTO userTO = loginToVistA(emrSvcPort, accessCode, verifyCode);
		UserSecurityKeyArray userSecurityKeyArray = emrSvcPort.getUserSecurityKeys(userTO.getDUZ());
		String mdwsSessionId = getSessionId(emrSvcPort);
		MhpUser mhpUser = createMhpUser(userTO, userSecurityKeyArray, this.baseEmrServiceUrl, mdwsSessionId, accessCode, siteCode);
		return mhpUser;
	}

	private EmrSvcSoap getEmrSvcPort(){
		URL emrSvcWsdlUrl = this.emrSvcWsdlUrl;
		
		EmrSvc emrService = null;
		emrService = new EmrSvc(emrSvcWsdlUrl);
		EmrSvcSoap port = emrService.getEmrSvcSoap();
		
		((BindingProvider)port).getRequestContext().put(BindingProvider.SESSION_MAINTAIN_PROPERTY, true);
		((BindingProvider)port).getRequestContext().put(BindingProvider.ENDPOINT_ADDRESS_PROPERTY, this.emrSvcUrl);	    

		return port;
	}
	
	private EmrSvcSoap connectToVistA(EmrSvcSoap emrSvcPort, String siteCode){
		DataSourceArray dsa = null;
		dsa = emrSvcPort.connect(siteCode);

		if (dsa.getFault() != null){
			throw new MdwsResponseException(MdwsResponseException.UserMessages.CONNECTION_ERROR, dsa.getFault().getMessage());			
		}
		
		return emrSvcPort;
	}
	
	private UserTO loginToVistA(EmrSvcSoap emrSvcPort, String accessCode, String verifyCode){
		UserTO userTO = emrSvcPort.login(accessCode, verifyCode, "");

		if (userTO.getFault() != null) {
			emrSvcPort.disconnect();
			throw new MdwsResponseException(MdwsResponseException.UserMessages.INVALID_ACCESS_VERIFY, userTO.getFault().getMessage());
		}
		
		return userTO;
	}
	
	private String getSessionId(EmrSvcSoap emrSvcPort) {
		Client client = ClientProxy.getClient(emrSvcPort);
		HTTPConduit httpConduit = (HTTPConduit)client.getConduit();
		Map<String, Cookie> cookies = httpConduit.getCookies();
		String sessionId = cookies.get("ASP.NET_SessionId").getValue();
		return sessionId;
	}
	
	private MhpUser createMhpUser(UserTO userTO, UserSecurityKeyArray userSecurityKeyArray, String baseEmrServiceUrl, String mdwsSessionId, String accessCode,
			String siteCode) {
		MhpUserCreater mhpUserCreator = new MhpUserCreater();
		return mhpUserCreator.createMhpUser(userTO, userSecurityKeyArray, baseEmrServiceUrl, mdwsSessionId, accessCode, siteCode);
	}
	
	private URL constructEmrSvclWsdlUrl(){
		StringBuffer buffer = new StringBuffer();
		String wsdlLocation = buffer.append(baseEmrServiceUrl).append("/")
				              .append(emrSvcName)
				              .append("?WSDL").toString();

		URL emrSvcWsdlUrl = null;
		try {
			emrSvcWsdlUrl = new URL(wsdlLocation);
		} catch (Exception e) {
			throw new MdwsResponseException(MdwsResponseException.UserMessages.INVALID_WSDL, e.getMessage());
		}
	
		return emrSvcWsdlUrl;
	}
	
	private String constructEmrSvcUrl(){
		StringBuffer buffer = new StringBuffer();
		String emrSvcUrl = buffer.append(baseEmrServiceUrl).append("/")
				              .append(emrSvcName).toString();
		return emrSvcUrl;
	}
	
	public URL getEmrSvcWsdlUrl(){
		return this.emrSvcWsdlUrl;
	}
	
	public String getEmrSvcUrl(){
		return this.emrSvcUrl;
	}
}
