package com.agilex.healthcare.mobilehealthplatform.security;

import java.util.Iterator;

import com.agilex.healthcare.mobilehealthplatform.domain.MdwsKey;
import com.agilex.healthcare.mobilehealthplatform.domain.MdwsKeys;
import com.agilex.healthcare.mobilehealthplatform.domain.MhpUser;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientIdentifier;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsInfo;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsResponseValidator;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserSecurityKeyArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserSecurityKeyTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.UserTO;
import com.agilex.healthcare.utility.NullChecker;

public class MhpUserCreater {

	public MhpUser createMhpUser(UserTO userTO, UserSecurityKeyArray userSecurityKeyArray, String emrSvcBaseUrl, 
			String sessionId, String accessCode, String siteCode){
		MhpUser mhpUser = translate(userTO);
		mhpUser.setAccessCode(accessCode);
		mhpUser.setVistaLocation(siteCode);
		
		PatientIdentifier userIdentifier = new PatientIdentifier("dfn-"+siteCode, userTO.getDUZ());
		mhpUser.setUserIdentifier(userIdentifier);
		mhpUser.setUserName(accessCode);
		mhpUser.setMdwsInfo(createMdwsInfo(mhpUser, sessionId, emrSvcBaseUrl, userSecurityKeyArray));
		
		return mhpUser;
	}
	
	private MhpUser translate(UserTO userTO){
		MhpUser mhpUser = new MhpUser();

		mhpUser.setDisplayName(userTO.getName());
		mhpUser.setTitle(userTO.getTitle());
		mhpUser = deriveIndividualNames(mhpUser, userTO);
		
		return mhpUser;
	}
	
	private MdwsInfo createMdwsInfo(MhpUser mhpUser, String sessionId, String baseUrl, UserSecurityKeyArray userSecurityKeyArray) {
		String userId = mhpUser.getUserIdentifier().toString();
		String username = mhpUser.getAccessCode();
		
		MdwsInfo mdwsInfo = new MdwsInfo();
		mdwsInfo.setUserId(userId);
		mdwsInfo.setUsername(username);
		mdwsInfo.setBaseUrl(baseUrl);
		mdwsInfo.setSessionId(sessionId);
		mdwsInfo.setKeys(createVistaSecurityKeys(userSecurityKeyArray));
		return mdwsInfo;
	}
	
	private MhpUser deriveIndividualNames(MhpUser mhpUser, UserTO userTO) {
		// Assuming "LAST,FIRST MIDDLE" Syntax
		String fullName = userTO.getName();

		if (NullChecker.isNotNullish(fullName)) {
			String[] names = fullName.trim().split(",");
			mhpUser.setLastName(names[0]);

			if(names.length > 1){
				String[] firstAndMiddleNames = names[1].toString().trim().split(" ");

				if(firstAndMiddleNames.length > 1){
					mhpUser.setFirstName(firstAndMiddleNames[0]);
					mhpUser.setMiddleInitials(firstAndMiddleNames[1]);
				}else{
					mhpUser.setFirstName(firstAndMiddleNames[0]);
				}
			}
		}
		return mhpUser;
	}
	
	public MdwsKeys createVistaSecurityKeys(UserSecurityKeyArray userSecurityKeyArray) {
		MdwsKeys vistaSecurityKeys = new MdwsKeys();
		
		MdwsResponseValidator.validateMdwsObject(userSecurityKeyArray);
		
		if (userSecurityKeyArray.getKeys() == null || userSecurityKeyArray.getKeys().getUserSecurityKeyTO() == null){
			return vistaSecurityKeys;
		}

		Iterator<UserSecurityKeyTO> it = userSecurityKeyArray.getKeys().getUserSecurityKeyTO().iterator();
		
		while (it.hasNext()) {
			UserSecurityKeyTO userSecurityKey = it.next();
			String id = userSecurityKey.getId();
			String name = userSecurityKey.getName();
			
			MdwsKey vistaSecurityKey = new MdwsKey();
			vistaSecurityKey.setId(id);
			vistaSecurityKey.setName(name);
			vistaSecurityKeys.add(vistaSecurityKey);
		}
		
		return vistaSecurityKeys;
	}

}
