package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import com.agilex.healthcare.utility.NullChecker;

public class TranslationHelper {

    // Assuming "(xyz) Facility Name" which is the format by VistaSites for some views in CDW.
    // if format does not match, it returns the original siteName
    public static String alterFacilityName(String siteName) {
        if(NullChecker.isNullish(siteName))
            return siteName;

        siteName = siteName.trim();
        if("(".equalsIgnoreCase(Character.toString(siteName.charAt(0)))) {
            return siteName.substring(6, siteName.length());
        }

        return siteName;
    }
}
