package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.*;

public class TaggedTextTranslator {

	public String translate(TaggedTextArray taggedTextArray) {
		if(taggedTextArray == null)
			return "";
		
		return unwrapArrayOfTaggedText(taggedTextArray.getResults());
	}

	private String unwrapArrayOfTaggedText(ArrayOfTaggedText array) {
		if(array == null)
			return "";
		
		return unwrapListOfTaggedText(array.getTaggedText());
	}
	
	private String unwrapListOfTaggedText(List<TaggedText> listOfTaggedText) {
		StringBuilder concat = new StringBuilder();
		if(listOfTaggedText == null || listOfTaggedText.size() == 0)
			return "";
		
		for(TaggedText taggedText : listOfTaggedText) {
			concat.append(taggedText.getText());
			concat.append("\n\n");
		}
		
		return concat.toString();
	}
}
