package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsDateTranslationUtil;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.*;

public class SurgeryTranslator {
	
	public Surgeries translate(TaggedSurgeryReportArrays surgeryReports) {
		if(surgeryReports == null)
			return new Surgeries();
		
		return unwrapArrayOfTaggedSurgeryReportArray(surgeryReports.getArrays());
	}		
	
	private Surgeries unwrapArrayOfTaggedSurgeryReportArray(ArrayOfTaggedSurgeryReportArray array) {
		if(array == null) 
			return new Surgeries();
				
		return unwrapListOfTaggedSurgeryReportArray(array.getTaggedSurgeryReportArray());
	}
	
	private Surgeries unwrapListOfTaggedSurgeryReportArray(List<TaggedSurgeryReportArray> arrays) {
		Surgeries surgeries = new Surgeries();
		
		if(arrays == null || arrays.size() == 0)
			return surgeries;
		
		for(TaggedSurgeryReportArray array : arrays) {
			surgeries.addAll(unwrapArrayOfSurgeryReports(array.getRpts()));
		}
		
		return surgeries;
	}
	
	private Surgeries unwrapArrayOfSurgeryReports(ArrayOfSurgeryReportTO reports) {
		if(reports == null)
			return new Surgeries();
		
		return unwrapListOfSurgeryReports(reports.getSurgeryReportTO());
	}
	
	private Surgeries unwrapListOfSurgeryReports(List<SurgeryReportTO> surgeryReports) {
		Surgeries surgeries = new Surgeries();
		
		if(surgeryReports == null || surgeryReports.size() == 0)
			return surgeries;
		
		for(SurgeryReportTO surgeryReport : surgeryReports) {
			surgeries.add(constructSurgeryReport(surgeryReport));
		}
		
		return surgeries;
	}
	
	private Surgery constructSurgeryReport(SurgeryReportTO surgeryReport) {
		Surgery surgery = new Surgery();
		
		surgery.setUniqueId(surgeryReport.getId());
		surgery.setProcedureDate(translateProcedureDate(surgeryReport.getTimestamp()));
		surgery.setProcedure(surgeryReport.getTitle());
		surgery.setFacility(translateFacility(surgeryReport.getFacility()));
		surgery.setSourceSystem(surgery.getFacility());
		
		return surgery;
	}
	
	private Date translateProcedureDate(String date) {
		MdwsDateTranslationUtil translator = new MdwsDateTranslationUtil();
		return translator.extractDateOrNull(date);
	}
	
	private String translateFacility(TaggedText facility) {
		if(facility == null) 
			return "";
		
		return facility.getTag();
	}
}
