package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageUser;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssigningAuthorityCode;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.SmUserTO;

public class SecureMessageUserTranslator {
	public static SecureMessageUser translateMhvSmUser(SmUserTO mhvUser) {
		SecureMessageUser user = new SecureMessageUser();
		
		user.setFirstName(mhvUser.getFirstName());
		user.setLastName(mhvUser.getLastName());
		user.setMiddleName(mhvUser.getMiddleName());
		user.setSsn(mhvUser.getSsn());
		user.setEmail(mhvUser.getEmail());
		user.setUsername(mhvUser.getUsername());
		user.setPatientIdentifier(AssigningAuthorityCode.SECURE_MESSAGE, Integer.toString(mhvUser.getId()));
		user.setUniqueId(Integer.toString(mhvUser.getId()));
		
		return user;
	}
}
