package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessage;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessages;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssigningAuthorityCode;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.AddresseeTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.ArrayOfAddresseeTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.ArrayOfMessageTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.ArrayOfThreadTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.FolderTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.MessageTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.SecureMessageThreadsTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.SmUserTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.ThreadTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.TriageGroupTO;
import com.agilex.healthcare.utility.DateHelper;

public class SecureMessageTranslator {
	public static SecureMessages translateMhvSecureMessageThreads(SecureMessageThreadsTO mhvSecureMessageThreads) {
		SecureMessages secureMessages = new SecureMessages();

		if (mhvSecureMessageThreads != null) {
			ArrayOfThreadTO mhvMessageThreads = mhvSecureMessageThreads.getMessageThreads();
			secureMessages.addAll(translateMhvMessageThreads(mhvMessageThreads));
		}

		return secureMessages;
	}

	static SecureMessages translateMhvMessageThreads(ArrayOfThreadTO mhvArrayOfThreads) {
		SecureMessages secureMessages = new SecureMessages();

		if (mhvArrayOfThreads != null) {
			for (ThreadTO mhvThread : mhvArrayOfThreads.getThreadTO()) {
				SecureMessages messages = translateThread(mhvThread);
				secureMessages.addAll(messages);
			}
		}
		return secureMessages;
	}

	public static SecureMessages translateThread(ThreadTO mhvThread) {
		SecureMessages secureMessages = new SecureMessages();

		if (mhvThread != null) {
			secureMessages.addAll(translateMessage(mhvThread.getMessages()));
		}

		for (SecureMessage message : secureMessages) {
			setValuesFromThread(message, mhvThread);
		}

		return secureMessages;
	}

	static SecureMessages translateMessage(ArrayOfMessageTO mhvArrayOfMessages) {
		SecureMessages secureMessages = new SecureMessages();

		if (mhvArrayOfMessages != null) {
			List<MessageTO> mhvMessages = mhvArrayOfMessages.getMessageTO();
			for (MessageTO mhvMessage : mhvMessages) {
				SecureMessage secureMessage = toSecureMessage(mhvMessage);
				secureMessages.add(secureMessage);
			}
		}

		return secureMessages;
	}

	public static SecureMessage toSecureMessage(MessageTO mhvMessage) {
		SecureMessage secureMessage = new SecureMessage();
		
		secureMessage.setThreadId(Integer.toString(mhvMessage.getThreadId()));
		secureMessage.setThreadOplock(Integer.toString(mhvMessage.getThreadOplock()));
		secureMessage.setUniqueId(Integer.toString(mhvMessage.getId()));
		secureMessage.setMessageOplock(Integer.toString(mhvMessage.getOplock()));
		secureMessage.setFrom(mhvMessage.getSenderName());
		secureMessage.setFromId(Integer.toString(mhvMessage.getSenderId()));
		secureMessage.setTo(mhvMessage.getRecipientName());
		secureMessage.setToId(Integer.toString(mhvMessage.getRecipientId()));
		secureMessage.setMessageBody(mhvMessage.getBody());
		secureMessage.setDateSent(DateHelper.toDate(mhvMessage.getSentDate()));
		secureMessage.setEscalationNotificationDate(DateHelper.toDate(mhvMessage.getEscalationNotificationDate()));
		secureMessage.setEscalatedDate(DateHelper.toDate(mhvMessage.getEscalatedDate()));
		secureMessage.setCompletedDate(DateHelper.toDate(mhvMessage.getCompletedDate()));
		setAddresseeValues(secureMessage, mhvMessage);

		return secureMessage;
	}

	static void setAddresseeValues(SecureMessage secureMessage, MessageTO mhvMessage) {
		ArrayOfAddresseeTO mhvArrayOfAddressee = mhvMessage.getAddressees();
		List<AddresseeTO> mhvAddressees = mhvArrayOfAddressee.getAddresseeTO();
		AddresseeTO mhvAddressee = mhvAddressees.get(0);
		secureMessage.setAddresseeId(Integer.toString(mhvAddressee.getId()));
		secureMessage.setAddresseeOplock(Integer.toString(mhvAddressee.getOplock()));
		
		setFolderValues(secureMessage, mhvAddressee.getFolder());
		setOwnerValues(secureMessage, mhvAddressee.getOwner());
		secureMessage.setReadDate(DateHelper.toDate(mhvAddressee.getReadDate()));
	}

	static void setFolderValues(SecureMessage secureMessage, FolderTO mhvFolder) {
		if (mhvFolder != null) {
			secureMessage.setFolder(mhvFolder.getName());
			secureMessage.setFolderId(Integer.toString(mhvFolder.getId()));
		}
	}

	static void setOwnerValues(SecureMessage secureMessage, SmUserTO mhvOwner) {
		if (mhvOwner != null) {
			secureMessage.setAddresseeOwnerId(Integer.toString(mhvOwner.getId()));
			secureMessage.setPatientIdentifier(AssigningAuthorityCode.SECURE_MESSAGE, Integer.toString(mhvOwner.getId()));
		}
	}

	static void setValuesFromThread(SecureMessage secureMessage, ThreadTO mhvThread) {
		if (mhvThread != null) {
			TriageGroupTO mailGroup = mhvThread.getMailGroup();
			if (mailGroup != null) {
				secureMessage.setMailGroup(Integer.toString(mailGroup.getId()));
			}
			secureMessage.setSubject(mhvThread.getSubject());
			secureMessage.setSubjectCategory(Integer.toString(mhvThread.getMessageCategory()));
			secureMessage.setReply(canEditToField(mhvThread));
		}
	}
	
	static boolean canEditToField(ThreadTO mhvThread) {
		ArrayOfMessageTO messages = mhvThread.getMessages();
		
		if(messages != null) {
			List<MessageTO> listOfMessages = messages.getMessageTO();
			if(listOfMessages != null)
				return listOfMessages.size() > 1;
		}
		
		return false;
	}
}
