package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageFolder;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageFolders;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.ArrayOfFolderTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.FolderTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.MailboxTO;

public class SecureMessageFolderTranslator {
	
	public static SecureMessageFolders translateMhvArrayOfFolderTo(MailboxTO mhvMailbox) {
		SecureMessageFolders folders = new SecureMessageFolders();
		if(mhvMailbox != null) {
			ArrayOfFolderTO mhvFolders = mhvMailbox.getFolders();
			if(mhvFolders != null) {
				for(FolderTO mhvFolder : mhvFolders.getFolderTO()) {
					SecureMessageFolder folder = toSecureMessageFolder(mhvFolder);
					folders.add(folder);
				}
			}
		}

		return folders;
	}

	private static SecureMessageFolder toSecureMessageFolder(FolderTO mhvFolder) {
		SecureMessageFolder folder = new SecureMessageFolder();
		
		folder.setUniqueId(Integer.toString(mhvFolder.getId()));
		folder.setName(mhvFolder.getName());
		folder.setSystemFolder(mhvFolder.isIsSystemFolder());

		return folder;
	}
}
