package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageContact;
import com.agilex.healthcare.mobilehealthplatform.domain.SecureMessageContacts;
import com.agilex.healthcare.mobilehealthplatform.domain.code.AssigningAuthorityCode;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.ArrayOfTriageGroupTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.TriageGroupTO;
import com.agilex.healthcare.utility.NullChecker;

public class SecureMessageContactTranslator {

	public static SecureMessageContacts translateMhvArrayOfTriageGroup(ArrayOfTriageGroupTO mhvArrayOfTriageGroup) {
		SecureMessageContacts contacts = new SecureMessageContacts();

		if(mhvArrayOfTriageGroup != null) {
			List<TriageGroupTO> triageGroups = mhvArrayOfTriageGroup.getTriageGroupTO();
			contacts.addAll(translateMhvTriageGroups(triageGroups));
		}

		return contacts;
	}

	private static SecureMessageContacts translateMhvTriageGroups(List<TriageGroupTO> triageGroups) {
		SecureMessageContacts contacts = new SecureMessageContacts();

		if(NullChecker.isNotNullish(triageGroups)) {
			for(TriageGroupTO triageGroup : triageGroups) {
				SecureMessageContact secureMessageContact = translateMhvTriageGroup(triageGroup);
				contacts.add(secureMessageContact);
			}
		}

		return contacts;
	}

	private static SecureMessageContact translateMhvTriageGroup(TriageGroupTO mhvTriageGroup) {
		SecureMessageContact contact = new SecureMessageContact();

		contact.setName(mhvTriageGroup.getName());
		contact.setUniqueId(Integer.toString(mhvTriageGroup.getId()));
		contact.setSourceSystem(AssigningAuthorityCode.SECURE_MESSAGE);

		return contact;
	}
	
}
