package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsDateTranslationUtil;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.*;

public class RadiologyTranslator {
	
	public RadiologyResults translate(TaggedRadiologyReportArrays taggedRadiologyReportArrays) {
		if(taggedRadiologyReportArrays == null)
			return new RadiologyResults();
		
		return unwrapArrayOfTaggedRadiologyReportArray(taggedRadiologyReportArrays.getArrays());
	}
	
	private RadiologyResults unwrapArrayOfTaggedRadiologyReportArray(ArrayOfTaggedRadiologyReportArray array) {
		if(array == null)
			return new RadiologyResults();
		
		return unwrapListOfTaggedRadiologyReportArrays(array.getTaggedRadiologyReportArray());
	}
	
	private RadiologyResults unwrapListOfTaggedRadiologyReportArrays(List<TaggedRadiologyReportArray> arrays) {
		RadiologyResults results = new RadiologyResults();
		
		if(arrays == null || arrays.size() == 0)
			return results;
		
		for(TaggedRadiologyReportArray reportArray : arrays) {
			results.addAll(unwrapArrayOfRadiologyReport(reportArray.getRpts()));
		}
		
		return results;
	}
	
	private RadiologyResults unwrapArrayOfRadiologyReport(ArrayOfRadiologyReportTO arrayOfReports) {
		if(arrayOfReports == null)
			return new RadiologyResults();
		
		return unwrapListOfRadiologyReports(arrayOfReports.getRadiologyReportTO());
	}
	
	private RadiologyResults unwrapListOfRadiologyReports(List<RadiologyReportTO> radiologyReports) {
		RadiologyResults results = new RadiologyResults();
		
		if(radiologyReports == null || radiologyReports.size() == 0)
			return results;
		
		for(RadiologyReportTO report : radiologyReports) {
			results.add(constructRadiologyResult(report));
		}
		
		return results;
	}

	private RadiologyResult constructRadiologyResult(RadiologyReportTO report) {
		RadiologyResult result = new RadiologyResult();
		
		result.setTestShortName(report.getTitle());
		result.setUniqueId(report.getId());
		result.setTestId(report.getId());
		result.setReport("REPORT:\n "+report.getText() + "\n\nIMPRESSION:\n "+report.getImpression());
		result.setTestName(report.getTitle());
		result.setSourceSystem(translateFacility(report.getFacility()));
		result.setFacilityName(translateFacility(report.getFacility()));
		result.setResultedDate(parseDate(report.getTimestamp()));

		return result;
	}
	
	private String translateFacility(TaggedText facility) {
		if(facility == null)
			return null;
		
		return facility.getTag(); // returns the station number TODO: Need to translate this somehow to a real facility name
	}
	
	private Date parseDate(String timestamp) {
		MdwsDateTranslationUtil dateTranslator = new MdwsDateTranslationUtil();
		return dateTranslator.extractDateOrNull(timestamp);
	}
}
