package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.PatientProvider;
import com.agilex.healthcare.mobilehealthplatform.domain.PatientProviders;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsDateTranslationUtil;
//import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.ArrayOfPatientCareTeamMemberTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.ArrayOfTaggedVisitArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.ArrayOfVisitTO;
//import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.PatientCareTeamMemberTO;
//import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.PatientCareTeamTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedVisitArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedVisitArrays;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.VisitTO;

public class ProviderTranslator {
//    public PatientProviders translate(PatientCareTeamTO careTeam) {
//        ArrayOfPatientCareTeamMemberTO members = careTeam.getMembers();
//        List<PatientCareTeamMemberTO> membersList = members.getPatientCareTeamMemberTO();
//
//        PatientProviders providers = new PatientProviders();
//        for (PatientCareTeamMemberTO member : membersList) {
//            PatientProvider provider = new PatientProvider();
//            
//            provider.setUniqueId(member.getPerson().getId());
//            provider.setProviderId(provider.getUniqueId());
//            provider.setProviderName(member.getPerson().getName());
//            provider.setPersonClass(member.getPrimaryStandardPosition());
//            provider.setVisitDate(extractMdwsDate(member.getTeamStartDate()));
//            providers.add(provider);
//
//        }
//
//        return providers;
//    }

    private Date extractMdwsDate(String timeStamp) {
        MdwsDateTranslationUtil translator = new MdwsDateTranslationUtil();
        return translator.extractDateOrNull(timeStamp);
    }

    public PatientProviders translate(TaggedVisitArrays arrays) {
        List<VisitTO> visitTOList = getVisitTOList(arrays);

        return translate(visitTOList);
    }

    public PatientProviders translate(List<VisitTO> visitTOList) {
        PatientProviders providers = new PatientProviders();
        for (VisitTO visitTO : visitTOList) {

            PatientProvider provider = new PatientProvider();
            provider.setProviderName(visitTO.getProvider().getName());
            provider.setPersonClass(visitTO.getProvider().getUserClass());
            provider.setVisitDate(extractMdwsDate(visitTO.getTimestamp()));

            providers.add(provider);
        }
        return providers;
    }

    public List<VisitTO> getVisitTOList(TaggedVisitArrays arrays) {
        List<VisitTO> result = new ArrayList<VisitTO>();

        ArrayOfTaggedVisitArray visitArray =  arrays.getArrays();
        List<TaggedVisitArray> taggedVisitArrayList =  visitArray.getTaggedVisitArray();
        for (TaggedVisitArray taggedVisitArray : taggedVisitArrayList) {
            ArrayOfVisitTO arrayOfVisitTO =  taggedVisitArray.getVisits();
            if (arrayOfVisitTO != null){
                List<VisitTO> visitTOList = arrayOfVisitTO.getVisitTO();

                for (VisitTO visitTO : visitTOList) {
                    result.add(visitTO);
                }
            }
        }
        return result;
    }
}
