package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.*;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsDateTranslationUtil;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.*;
import com.agilex.healthcare.utility.*;

public class ProblemTranslator {

	public Problems translateMdwsTaggedProblemArrays(TaggedProblemArrays mdwsTaggedProblemArrays) {
		if (mdwsTaggedProblemArrays == null)
			return new Problems();

		return unwrapArrayOfTaggedProblemArrays(mdwsTaggedProblemArrays.getArrays());
	}

	private Problems unwrapArrayOfTaggedProblemArrays(ArrayOfTaggedProblemArray arrayOfTaggedProblemArray) {
		if (arrayOfTaggedProblemArray == null)
			return new Problems();

		return unwrapArrayOfTaggedProblems(arrayOfTaggedProblemArray.getTaggedProblemArray());
	}

	private Problems unwrapArrayOfTaggedProblems(List<TaggedProblemArray> taggedProblemArray) {
		Problems problems = new Problems();

		if (taggedProblemArray == null || taggedProblemArray.size() == 0)
			return problems;

		for (TaggedProblemArray taggedProblem : taggedProblemArray) {
			problems.addAll(unwrapArrayOfProblems(taggedProblem.getProblems()));
		}

		return problems;
	}

	private Problems unwrapArrayOfProblems(ArrayOfProblemTO arrayOfProblemTos) {
		if (arrayOfProblemTos == null)
			return new Problems();

		return unwrapListOfProblemTO(arrayOfProblemTos.getProblemTO());
	}

	private Problems unwrapListOfProblemTO(List<ProblemTO> problemTos) {
		Problems problems = new Problems();

		if (problemTos == null || problemTos.size() == 0)
			return problems;

		for (ProblemTO problemTo : problemTos) {
			problems.add(constructProblem(problemTo));
		}

		return problems;
	}

	private Problem constructProblem(ProblemTO problemTo) {
		assert problemTo != null;

		Problem problem = new Problem();
		setId(problem, problemTo);

		problem.setDescription(providerNarrative(problemTo));
		problem.setActive(isActive(problemTo.getStatus()));
		problem.setComments(problemTo.getComment());
		setDates(problem, problemTo);
		setFacility(problem, problemTo);

		return problem;
	}

	private void setId(Problem problem, ProblemTO mdwsProblem) {
		String id = "BLANK";

		if (mdwsProblem.getId() != null)
			id = mdwsProblem.getId();

		problem.setUniqueId(id);
	}

	private boolean isActive(String mdwsStatusString) {
		String vistaActiveStatus = "A";
		String cdwActiveStatus = "Y";
		if (vistaActiveStatus.equals(mdwsStatusString) || cdwActiveStatus.equals(mdwsStatusString))
			return true;
		else
			return false;
	}

	void setDates(Problem problem, ProblemTO problemTo) {
		assert problem != null;
		assert problemTo != null;

		if (problemTo.getOnsetDate() != null)
			problem.setOnsetDate(parseDate(problemTo.getOnsetDate()));

		if (problemTo.getResolvedDate() != null)
			problem.setResolutionDate(parseDate(problemTo.getResolvedDate()));

		if (problemTo.getModifiedDate() != null)
			problem.setLastUpdatedDate(parseDate(problemTo.getModifiedDate()));
	}

	private Date parseDate(String mdwsDate) {
		MdwsDateTranslationUtil util = new MdwsDateTranslationUtil();
		return util.extractDateOrNull(mdwsDate);
	}

	private void setFacility(Problem problem, ProblemTO problemTo) {
		TaggedText facility = problemTo.getFacility();
		String sourceSystem = stripSiteCodeFromFacilityName(facility.getTag());
		problem.setSourceSystem(sourceSystem);
	}

	private String providerNarrative(ProblemTO problemTo) {
		String providerNarrative = problemTo.getProviderNarrative();
		return NullChecker.isNotNullish(providerNarrative) ? providerNarrative.trim() : "Blank Narrative";
	}

	private String stripSiteCodeFromFacilityName(String facilityName) {
		if (facilityName != null && facilityName.contains("("))
			return matchFacilityName(facilityName);

		return facilityName;
	}

	String matchFacilityName(String facilityName) {
		// Matches something like "(321) City Name, ST" -> {"(321)",
		// "City Name, ST"}
		String altered = facilityName.replaceAll("\\([0-9]{3,4}\\)", "");
		return altered.trim();

	}
}
