package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.*;

import com.agilex.healthcare.mobilehealthplatform.domain.LabResult;
import com.agilex.healthcare.mobilehealthplatform.domain.LabResults;
import com.agilex.healthcare.mobilehealthplatform.mdws.MdwsDateTranslationUtil;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.ArrayOfMicrobiologyRpt;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.ArrayOfTaggedMicrobiologyRptArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.LabSpecimenTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.MicrobiologyRpt;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedMicrobiologyRptArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.TaggedMicrobiologyRptArrays;
import com.agilex.healthcare.utility.NullChecker;

public class MicrobiologyLabTranslator {

	public LabResults translate(TaggedMicrobiologyRptArrays taggedMicrobiologyRptArrays) {
		if (taggedMicrobiologyRptArrays == null)
			return new LabResults();

		return unwrapArrayOfTaggedMicrobiologyRptArray(taggedMicrobiologyRptArrays.getArrays());
	}

	private LabResults unwrapArrayOfTaggedMicrobiologyRptArray(ArrayOfTaggedMicrobiologyRptArray arrayOfTaggedMicrobiologyRptArray) {
		if (arrayOfTaggedMicrobiologyRptArray == null)
			return new LabResults();

		return unwrap(arrayOfTaggedMicrobiologyRptArray.getTaggedMicrobiologyRptArray());
	}

	private LabResults unwrap(List<TaggedMicrobiologyRptArray> list) {
		LabResults results = new LabResults();
		if (list == null || list.size() == 0)
			return new LabResults();

		for (TaggedMicrobiologyRptArray taggedMicrobiologyRptArray : list) {
			results.addAll(unwrap(taggedMicrobiologyRptArray));
		}

		return results;
	}

	private LabResults unwrap(TaggedMicrobiologyRptArray taggedMicrobiologyRptArray) {
		if (taggedMicrobiologyRptArray == null)
			return new LabResults();

		return unwrap(taggedMicrobiologyRptArray.getRpts());
	}

	private LabResults unwrap(ArrayOfMicrobiologyRpt arrayOfMicrobiologyRpt) {
		if (arrayOfMicrobiologyRpt == null)
			return new LabResults();

		return unwrapMicrobiologyReports(arrayOfMicrobiologyRpt.getMicrobiologyRpt());
	}

	private LabResults unwrapMicrobiologyReports(List<MicrobiologyRpt> list) {
		LabResults results = new LabResults();

		if (list == null || list.size() == 0)
			return results;

		for (MicrobiologyRpt microbiologyReport : list) {
			results.add(constructLabResult(microbiologyReport));
		}

		return results;
	}

	private LabResult constructLabResult(MicrobiologyRpt microbiologyReport) {
		LabResult labResult = new LabResult();
		
		setIdentifier(microbiologyReport, labResult);
		labResult.setTestname(microbiologyReport.getTitle());
		labResult.setLabType(microbiologyReport.getSample());
		labResult.setDisplayName(microbiologyReport.getTitle());
		labResult.setDisplayDescription(microbiologyReport.getTitle());
		labResult.setValue(microbiologyReport.getText());

		setSpeciminData(labResult, microbiologyReport.getSpecimen());

		labResult.setComment(microbiologyReport.getComment());
		labResult.setResultedDate(extractDate(microbiologyReport.getTimestamp()));

		return labResult;
	}

	private void setSpeciminData(LabResult labResult, LabSpecimenTO specimen) {
		if (specimen != null) {
			labResult.setSpecimenId(specimen.getId());
			labResult.setSpecimenName(specimen.getName());
			labResult.setAccessionNumber(specimen.getAccessionNum());
			labResult.setOrderId(specimen.getAccessionNum());
		}
	}

	private void setIdentifier(MicrobiologyRpt microbiologyReport, LabResult labResult) {
		// Handle scenarios where microbiology reports don't have identifiers
		if(NullChecker.isNullish(microbiologyReport.getId()))
			labResult.setUniqueId(UUID.randomUUID().toString());
		else
			labResult.setUniqueId(microbiologyReport.getId());
	}
	
	private Date extractDate(String date) {
		MdwsDateTranslationUtil dateTranslator = new MdwsDateTranslationUtil();
		return dateTranslator.extractDateOrNull(date);
	}

}