package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.Date;
import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.Medication;
import com.agilex.healthcare.mobilehealthplatform.domain.Medications;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.ArrayOfMedicationTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.ArrayOfTaggedMedicationArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.MedicationTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.TaggedMedicationArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.mhvservice.TaggedMedicationArrays;
import com.agilex.healthcare.utility.DateHelper;

public class MedicationRefillTranslator {

	public Medications translateTaggedMedications(TaggedMedicationArrays mdwsTaggedMedicationArrays) {		
		if(mdwsTaggedMedicationArrays == null)
			return new Medications();
		
		return unwrapArrayOfTaggedMedicationArray(mdwsTaggedMedicationArrays.getArrays());
	}
	
	private Medications unwrapArrayOfTaggedMedicationArray(ArrayOfTaggedMedicationArray mdwsArrayOfTaggedArray) {
		if(mdwsArrayOfTaggedArray == null)
			return new Medications();
				
		return unwrapTaggedMedicationArrays(mdwsArrayOfTaggedArray.getTaggedMedicationArray());
	}
	
	private Medications unwrapTaggedMedicationArrays(List<TaggedMedicationArray> mdwsTaggedMedicationArrays) {
		Medications medications = new Medications();
		if(mdwsTaggedMedicationArrays == null || mdwsTaggedMedicationArrays.size() == 0)
			return medications;
		
		for(TaggedMedicationArray taggedMedicationArray : mdwsTaggedMedicationArrays) {
			medications.addAll(unwrapTaggedMedicationArray(taggedMedicationArray));
		}
		
		return medications;
	}
	
	private Medications unwrapTaggedMedicationArray(TaggedMedicationArray taggedMedicationArray) {
		if(taggedMedicationArray == null)
			return new Medications();
				
		return unwrapArrayOfMedications(taggedMedicationArray.getMeds());
	}
	
	private Medications unwrapArrayOfMedications(ArrayOfMedicationTO arrayOfMedications) {
		if(arrayOfMedications == null) 
			return new Medications();
			
		return unwrapListOfMedications(arrayOfMedications.getMedicationTO());
	}
	
	private Medications unwrapListOfMedications(List<MedicationTO> mdwsMedications) {
		Medications medications = new Medications();
		if(mdwsMedications == null || mdwsMedications.size() == 0)
			return medications;
		
		for(MedicationTO mdwsMedication : mdwsMedications) {
			Medication translated = createMedication(mdwsMedication);
			medications.add(translated);
		}
		
		return medications;
	}
	
	public Medication createMedication(MedicationTO mdwsMedication) {
		Medication medication = new Medication();
		
		medication.setUniqueId(mdwsMedication.getId());
		medication.setDrugName(mdwsMedication.getName());
		medication.setDaysSupply(mdwsMedication.getDaysSupply());
		medication.setOrderNumber(mdwsMedication.getOrderId());
		medication.setPrescriptionId(mdwsMedication.getRxNum());
		medication.setRefills(mdwsMedication.getRefills());
		medication.setQuantity(mdwsMedication.getQuantity());
		medication.setSig(mdwsMedication.getSig());
		medication.setExpiredDate(parseDateOrNull(mdwsMedication.getExpirationDate()));
		medication.setLastFilledDate(parseDateOrNull(mdwsMedication.getLastFillDate()));
		medication.setEndDate(parseDateOrNull(mdwsMedication.getExpirationDate()));
		
		medication.setStatus(mdwsMedication.getStatus());

		return medication;
	}
	
	private Date parseDateOrNull(String vistaDate) {
		try {
			return DateHelper.parse(vistaDate, DateHelper.VISTA_DOB_DATE_FORMAT);
		} catch (RuntimeException e) {
			return null;
		}
	}
 } 
