package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.Facilities;
import com.agilex.healthcare.mobilehealthplatform.domain.Facility;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.ArrayOfSiteTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.SiteArray;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.SiteTO;
import com.agilex.healthcare.utility.NullChecker;

public class FacilityTranslator {
	
	public Facilities translateSitesToFacilities(SiteArray mdwsSites) {
		Facilities facilities = new Facilities();
		
		if(mdwsSites == null)
			return facilities;
				
		return unwrapArrayOfSites(mdwsSites.getSites());
	}
	
	public Facilities unwrapArrayOfSites(ArrayOfSiteTO mdwsArrayOfSites) {
		Facilities facilities = new Facilities();
		
		if(mdwsArrayOfSites == null) 
			return facilities;
		
		
		return unwrapSites(mdwsArrayOfSites.getSiteTO());
	}
	
	private Facilities unwrapSites(List<SiteTO> mdwsSiteList) {
		Facilities facilities = new Facilities();
		
		if(mdwsSiteList == null || mdwsSiteList.size() == 0)
			return facilities;
		
		for(SiteTO mdwsSite : mdwsSiteList) {
			Facility facility = createFacility(mdwsSite);
			facilities.add(facility);
		}
		
		return facilities;
	}
	
	private Facility createFacility(SiteTO site) {
		Facility facility = new Facility();
		
		facility.setAddress(site.getAddress());
		facility.setParentSiteCode(site.getParentSiteId());
		facility.setName(alterFacilityName(site.getName()));
		facility.setType(site.getSiteType());
		facility.setFacilityCode(site.getSystemName());
		facility.setState(site.getState());
		facility.setCity(site.getCity());
		
		return facility;
	}
	
	// Assuming "(xyz) Facility Name", but handles sites without site code in the name
	public String alterFacilityName(String siteName) {
		if(NullChecker.isNullish(siteName))
			return siteName;
		
		siteName = siteName.trim();
		if("(".equalsIgnoreCase(Character.toString(siteName.charAt(0)))) {
			return siteName.substring(6, siteName.length());
		}
		
		return siteName;
	}
}
