package com.agilex.healthcare.mobilehealthplatform.mdws.translator;

import java.util.List;

import com.agilex.healthcare.mobilehealthplatform.domain.*;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.AddressTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.ArrayOfAddressTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.ArrayOfDemographicSetTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.ArrayOfPhoneNumTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.ArrayOfString;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.DemographicSetTO;
import com.agilex.healthcare.mobilehealthplatform.mdws.generatedwsdl.emrservice.PhoneNumTO;

public class DemographicTranslator {

	private final String WORK_PHONE = "Work Phone";
	private final String HOME_PHONE = "Home Phone";

	public PatientDemographics translate(ArrayOfDemographicSetTO demographics) {
		if (demographics == null)
			return new PatientDemographics();

		return unwrap(demographics.getDemographicSetTO());
	}

	PatientDemographics unwrap(List<DemographicSetTO> listOfDemographicSet) {
		if (listOfDemographicSet == null || listOfDemographicSet.size() == 0)
			return new PatientDemographics();

		return constructPatientDemographics(listOfDemographicSet.get(0));
	}

	PatientDemographics constructPatientDemographics(DemographicSetTO demographicSet) {
		PatientDemographics patientDemographics = new PatientDemographics();

		tryToSetPhoneNumbers(patientDemographics, demographicSet);
		tryToSetAddress(patientDemographics, demographicSet);
		setEmailAddress(patientDemographics, demographicSet);
		// NextOfKin not available

		return patientDemographics;
	}

	void setEmailAddress(PatientDemographics patientDemographics, DemographicSetTO mdwsPatientDemographicSet) {
		ArrayOfString mdwsEmailAddresses = mdwsPatientDemographicSet.getEmailAddresses();
		String emailAddresses = "";
		if (mdwsEmailAddresses != null && mdwsEmailAddresses.getString() != null) {
			for (String emailAddress : mdwsEmailAddresses.getString()) {
				emailAddresses += emailAddress;
			}
		}
		patientDemographics.setEmailAddress(emailAddresses);
	}

	void tryToSetPhoneNumbers(PatientDemographics patientDemographics, DemographicSetTO mdwsPatientDemographicSet) {
		ArrayOfPhoneNumTO mdwsPhones = mdwsPatientDemographicSet.getPhones();
		if (mdwsPhones != null && mdwsPhones.getPhoneNumTO() != null) {
			DemographicTranslator translator = new DemographicTranslator();
			for (PhoneNumTO mdwsPhone : mdwsPhones.getPhoneNumTO()) {
				String phoneNumber = translator.formatPhoneNumber(mdwsPhone);
				if (WORK_PHONE.equalsIgnoreCase(mdwsPhone.getDescription())) {
					patientDemographics.setPhoneNumberWork(phoneNumber);
				} else if (HOME_PHONE.equalsIgnoreCase(mdwsPhone.getDescription())) {
					patientDemographics.setPhoneNumberHome(phoneNumber);
				} else {
					patientDemographics.setPhoneNumberMobile(phoneNumber);
				}
			}
		}
	}

	void tryToSetAddress(PatientDemographics patientDemographics, DemographicSetTO mdwsPatientDemographicSet) {
		ArrayOfAddressTO mdwsAddresses = mdwsPatientDemographicSet.getAddresses();
		if (mdwsAddresses != null && mdwsAddresses.getAddressTO() != null) {
			Addresses addresses = new Addresses();
			for (AddressTO mdwsAddress : mdwsAddresses.getAddressTO()) {
				Address address = formatAddress(mdwsAddress);
				addresses.add(address);
				patientDemographics.setAddress(address);
			}
			patientDemographics.setAddresses(addresses);
		}
	}

	Address formatAddress(AddressTO mdwsAddress) {
		Address address = new Address();

		address.setStreetAddressLine1(mdwsAddress.getStreetAddress1());
		address.setStreetAddressLine2(mdwsAddress.getStreetAddress2());
		address.setStreetAddressLine3(mdwsAddress.getStreetAddress3());
		address.setCity(mdwsAddress.getCity());
		address.setState(mdwsAddress.getState());
		address.setZipCode(mdwsAddress.getZipcode());

		return address;
	}

	String formatPhoneNumber(PhoneNumTO mdwsPhoneNumber) {
		String areaCode = mdwsPhoneNumber.getAreaCode() == null ? "" : mdwsPhoneNumber.getAreaCode();
		String exchange = mdwsPhoneNumber.getExchange() == null ? "" : mdwsPhoneNumber.getExchange();
		String number = mdwsPhoneNumber.getNumber() == null ? "" : mdwsPhoneNumber.getNumber();

		// (123)-456-7890
		return new StringBuilder().append("(").append(areaCode).append(")-").append(exchange).append("-").append(number).toString();
	}

}
